/*
Coiled-NNUE is a UCI chess playing engine authored by Oscar Gavira.
Copyright (C) 2013-2021 Oscar Gavira.
<https://github.com/Oscar-Gavira/Coiled-NNUE>

Coiled-NNUE is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Coiled-NNUE is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TBPROBE_H
#define TBPROBE_H

#include "Externo.h"

#ifdef USAR_TBPROBE													/* Comprobamos si esta definido */

/**************************************************************************************
						ENUMERACIONES/ESTRUCTURA
			Internas para manejar la tablas bases Gaviota
**************************************************************************************/
enum TBvalores														/* Valores devueltos por la tabla de finales */
{
   TBDRAW = 0,														/* Valor de empate */
   TBWMATE = 1,														/* Valor ganan las blancas */
   TBBMATE = 2,														/* Valor ganan las negras */
   TBFORBID = 3,													/* Valor a descartar */
   TBUNKNOWN = 7													/* No existe en la tabla de finales */
};
/**************************************************************************************
						VARIABLE PARA MANEJAR GTB
**************************************************************************************/
typedef struct tag_Gaviota
{
	int Usar;														/* Se puede usar la tablas de gaviota (true/false) */
	U64 Acierto;													/* Cuando buscamos en la tabla y encontramos resultados, se va incrementando */
	int Dll_Cargada;												/* Esta cargada la DLL */
	unsigned int Tablas_Disponibles;								/* Que tablas de finales estn disponibles */
	char Directorio[MAX_DIR];										/* Obtenemos las rutas a las tablas de finales */
	int DirectorioNuevo;											/* Indica si hay cambio de ruta a las tablas de finales */
	int	Compresion;													/* Compresin de las tablas de finales */
	int Informacion;												/* Muestra informacin true/false */
	U64 CacheMB;													/* 32 MiB */
	int CacheNueva;													/* Indica si hay un cambio en el tamaa de la cache true/false */
	int Fraccion;													/* Fraccin de tipo WDL y DTZ */
	const char **paths;												/* Rutas para acceder a las tablas de finales */
	int Limite;														/* Indica a partir de que numero de pieza busca en las tablas de finales */
} _ST_Gaviota;

_ST_Gaviota Gaviota;
/**************************************************************************************
						METODOS DISPONIBLE DE LA DLL
**************************************************************************************/
/* Inicia la carga de la informacin */
typedef char * (CDECL *TBINIT)	(int verbosity, int compression_scheme, const char **paths);
/* Reinicia - Recarga la nueva informacin (Unido a tbcahe_restart) */
typedef char * (CDECL *TBRESTART) (int verbosity, int compression_scheme, const char **paths);
/* Descarga la tb */
typedef void (CDECL *TBDONE) (void);
/* Busca informacin en la cache y si no encuentra ira al hdd (El comn a usar) */
typedef int (CDECL *TBPROBE_HARD) (unsigned stm, unsigned epsq, unsigned castles, const unsigned *inp_wSQ, const unsigned *inp_bSQ, const unsigned char *inp_wPC, const unsigned char *inp_bPC, unsigned *tbinfo, unsigned *plies);
typedef int (CDECL *TBPROBE_SOFT) (unsigned stm, unsigned epsq, unsigned castles, const unsigned *inp_wSQ, const unsigned *inp_bSQ, const unsigned char *inp_wPC, const unsigned char *inp_bPC, unsigned *tbinfo, unsigned *plies);
typedef int (CDECL *TBPROBE_WDL_HARD) (unsigned stm, unsigned epsq, unsigned castles, const unsigned *inp_wSQ, const unsigned *inp_bSQ, const unsigned char *inp_wPC, const unsigned char *inp_bPC, unsigned *tbinfo);
typedef int (CDECL *TBPROBE_WDL_SOFT) (unsigned stm, unsigned epsq, unsigned castles, const unsigned *inp_wSQ, const unsigned *inp_bSQ, const unsigned char *inp_wPC, const unsigned char *inp_bPC, unsigned *tbinfo);
typedef int (CDECL *TBIS_INITIALIZED) (void);
/* Obtenemos informacin acerca de la tablas cargadas */
typedef unsigned int (CDECL *TBAVAILABILITY) (void);
/* Inicia la cache */
typedef int (CDECL *TBCACHE_INIT) (size_t cache_mem, int wdl_fraction);
/* Descarga la cache */
typedef void (CDECL *TBCACHE_DONE) (void);
typedef int (CDECL *TBCACHE_IS_ON) (void);
typedef const char ** (CDECL *TBPATHS_INIT) (void);
typedef const char ** (CDECL *TBPATHS_ADD) (const char **ps, const char *newpath);
typedef const char ** (CDECL *TBPATHS_DONE) (const char **ps);

TBINIT TBinit;									/* Inicializa la tabla de finales */
TBIS_INITIALIZED TBis_initialized;				/* Indica si la tabla esta inicializada */
TBRESTART TBrestart;							/* Reinicia la tabla de finales */
TBDONE TBdone;									/* Libera la tabla de finales */

TBPROBE_HARD TBprobe_hard;
TBPROBE_SOFT TBprobe_soft;
TBAVAILABILITY TBavailability;					/* Indica la tablas disponibles */
TBCACHE_INIT TBcache_init;						/* Inicia la cache y fraccin */
TBCACHE_DONE TBcache_done;						/* Borra la cache */
TBCACHE_IS_ON TBcache_is_on;

TBPATHS_INIT TBpaths_init;						/* Inicializa las rutas */
TBPATHS_ADD TBpaths_add;						/* Aade rutas */
TBPATHS_DONE TBpaths_done;						/* Libera ruta */

/**************************************************************************************
								Mtodos
**************************************************************************************/
int Cargar_gaviota_dll();
int Descargar_gaviota_dll();
int Probar_gaviota(int *puntos, int *ply);

#endif

#endif
