/*
Coiled-NNUE is a UCI chess playing engine authored by Oscar Gavira.
Copyright (C) 2013-2021 Oscar Gavira.
<https://github.com/Oscar-Gavira/Coiled-NNUE>

Coiled-NNUE is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Coiled-NNUE is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include "Externo.h"
#include "Fen.h"
#include "Hash.h"
#include "GeneradorDeMovimientos.h"
#include "Perft.h"

#ifdef USAR_SQLITE
	#include "LibroAperturas.h"
#endif
#ifdef USAR_TBPROBE
	#include "tbprobe.h"
#endif
#ifdef USAR_NNUE
	#include "nnue.h"
#endif
/*******************************************************************************
									Mtodos
*******************************************************************************/
void UciEntrada(char *ptr);									/* Procesa las entradas */
void LeerComandos(char *entrada, int longitud);				/* Lee las entradas */
void InicioBusqueda(char *ptr);								/* Empieza a analizar */
void Setoption(char *ptr);									/* Filtra las opciones recibidas */
void UciNewGame();											/* Inicia las variables */
void CargarNnue();											/* Carga las NNue */
void CargarGaviotaTB();										/* Carga las GaviotaTB */
void CacheGaviotaTB();										/* Establecemos cache GaviotaTB */
void IniciarConfiguracion();								/* Inicia la configuracin */

/******************************************************************************
Iniciamos las variables globales
*******************************************************************************/

_ST_TableroX64 TableroGlobal;									/* Tablero actual. */
_ST_TipoJuego TipoJuego;										/* Almacena informacin del juego por tiempo. */
_ST_Puntos Blancas;												/* Almacenamos informacin de la evaluacin de las blancas */
_ST_Puntos Negras;												/* Almacenamos informacin de la evaluacin de las negras */
int Salir;														/* Indica al programa que salga, para evitar un "exit(EXIT_FAILURE)" sin liberar la tabla hash */

#ifdef ARC_64BIT
U64 zobrist_Tablero[14][64] = {
{ (U64)0xBFACF94C33349DBA, (U64)0x378D114F3610E99D, (U64)0xC58162EA0F809985, (U64)0x30953FE760210A01, (U64)0x5A98784C5FA58438, (U64)0x695A3AC1EC390F0A, (U64)0x5129CB6753161046, (U64)0x1BEEB565D35CEE74, (U64)0xC6D009B391738BB8, (U64)0x600964F3CDD3FF77, (U64)0xF0219E3696C30BC6, (U64)0x4739D25AFA560D0B, (U64)0x65F891F2957ED27A, (U64)0x1AFEC31D7ECC190B, (U64)0x51D2EDBB8C51744, (U64)0x1CFEDCD809BF7177, (U64)0xC159600F598AC8F9, (U64)0x54318D0EE5AC7D34, (U64)0xA11DD589F45C1CA6, (U64)0x160933F41AC9934A, (U64)0x3051795F3F194779, (U64)0x4FE6CBA2D2078D49, (U64)0xA35C46430880526, (U64)0x68D22507A3E27735, (U64)0xB56F8D52F74D5EBB, (U64)0x9D156430236F6A34, (U64)0xDE9D7C75588F1AA5, (U64)0x2B854B09100A8148, (U64)0x1471CA1AAC25D39, (U64)0xD04A2A1F18108E0B, (U64)0x7F81BDB8967B9B67, (U64)0x7772C4BB23216174, (U64)0x624775EDAE5640A9, (U64)0xEA8C1CED8BB07477, (U64)0x4AA18CC892E884E7, (U64)0x6CB4A2B5FA55870B, (U64)0xCEEFE53C40875B4A, (U64)0xA47BD7E3BAFB100A, (U64)0xAEC954055EB59D65, (U64)0x66FE806CDDFF276, (U64)0x7FD354510C81D7C8, (U64)0xFFAAF94101C1F215, (U64)0x3DC1E176383397E6, (U64)0x589A4FEA77B6126B, (U64)0xBADB8D80C87CCC48, (U64)0xE555BF5CF3AC0668, (U64)0x996DB96A74A6C826, (U64)0x53CD11F864DCF494, (U64)0xEFBBDACA6EAD5CA, (U64)0x880210FEEA06E014, (U64)0x745F08ABA976D1A4, (U64)0x8B2A3F57D5EB08E8, (U64)0xADF3647F6ABBDA09, (U64)0xDAC556C05D67416B, (U64)0xC55789D6AF795A06, (U64)0xDCF1F8657E03AAD5, (U64)0x495FC1326E3DC389, (U64)0x903628027E5DB756, (U64)0x417FF117478D47C6, (U64)0xF626D6EB0D284EAA, (U64)0xDC6791C226A0D80B, (U64)0x8FA927BDE5B2D32B, (U64)0xB25B606B0B1A5C45, (U64)0xA89190D19C503DD7 },
{ (U64)0x75672A87C0F45DC9, (U64)0xE57EC19FD4FA3154, (U64)0x16D391A8CF4A5CC7, (U64)0xE1C6BB14A7D7D9EB, (U64)0xC10FDBBE8C574749, (U64)0xB809CB0327C9CD68, (U64)0xB3EB89B581C54307, (U64)0xFB0D653E10BD3F94, (U64)0x2221C36B518358CA, (U64)0xA2CAAC209C212D15, (U64)0x2C37C55AD51FA05, (U64)0x94FA218823D4CFF9, (U64)0xB6A97221571451A8, (U64)0xE81520FE8D0FCA7A, (U64)0xC6C7E5086904F586, (U64)0xCE2D0E82FA6E29E4, (U64)0x1399B3D43B490A28, (U64)0x37E24EDC3E663E67, (U64)0x79EF856927A6EC46, (U64)0x9CF2C835490B4D9B, (U64)0xF2B18B9DF7C917AA, (U64)0x1535596204545C9B, (U64)0x597714B4C37BF7C4, (U64)0x9185E6FF7321B7E7, (U64)0xC6BD5E68B11E9C69, (U64)0x4876B761F3BFB8E4, (U64)0xBC5EADB68AEDF856, (U64)0xEB44A9CBE258529A, (U64)0x619DE660790A84E9, (U64)0x128BF9DDEAF34ED9, (U64)0x2D7AFD4BD6B8E0B6, (U64)0xA4931F60D1D2B2A5, (U64)0xB925B7B555A19B6B, (U64)0x185CDEDF59C8AEA4, (U64)0x8930441A50387B35, (U64)0xBE6C55763ABD44D8, (U64)0x1C2D06DE91759AA9, (U64)0x67AB1431FA2848DB, (U64)0x7E1891F73CE77EB7, (U64)0xE4BB7ADC0D9DA0A4, (U64)0xBD01CE8ADF628529, (U64)0x2D783382C30335E7, (U64)0xDEA0B1A7F0F36577, (U64)0x29D8BCCA9C66C29B, (U64)0x4B01FF63BBB61CAA, (U64)0x34376D8C106DD79A, (U64)0x53A46A6AB65478F5, (U64)0x130FD321270E36E6, (U64)0xCE296E76763F1748, (U64)0x62C0C33E23D433E5, (U64)0xA28CDB597A853376, (U64)0x50D0D5151420D19B, (U64)0x7E9196BF68E908C8, (U64)0x81784339AB6C3F8, (U64)0x4A4039556932BF6, (U64)0xE273B9FE5D33184, (U64)0xDB9F83CBACFC104A, (U64)0x578C8AC10DFF6584, (U64)0xB1AC32C4104EB434, (U64)0x14B42428FEDB8F78, (U64)0x36BF7A00C45A1BC9, (U64)0x5F7B6CEF3FC181FB, (U64)0x111883A9D8CABDB6, (U64)0x79F342224CB06F05 },
{ (U64)0xA4D7EA7508830609, (U64)0x43C277DC428F286, (U64)0xC4304B78BD19A616, (U64)0x230CC8C4759C093A, (U64)0x1DF8BAD4E979D8B, (U64)0xDAEB1952F50A16BB, (U64)0x61387E54710DA3DD, (U64)0x28DBAFFEC26FFD47, (U64)0xF16312A802409C09, (U64)0xF010DFC06E61F0C4, (U64)0xCB18AE876FA2B85F, (U64)0x760AE17B51071D3B, (U64)0xD443A2D1AEC483C9, (U64)0xA3C5F06C5DDD08B8, (U64)0xBE0417C2AB7627DF, (U64)0x15FD4F413A2CFA04, (U64)0x714BFB14E89F9A4A, (U64)0xEF02B617FCB6EE85, (U64)0x3EAE463BC7672F1D, (U64)0x49B218C78BD20E79, (U64)0xA3634E6E240AD4D8, (U64)0xF475189147BE0EFA, (U64)0x8B86FE7F89B1349E, (U64)0x536536FD98D34C04, (U64)0xE5F9EAB41ACCD38, (U64)0x9AAE57AB10485887, (U64)0x6E863F824D3C299E, (U64)0x1896F81A23B9A81B, (U64)0xBADFB5B28B79563A, (U64)0xC0792129A323BD9B, (U64)0xCCAE0E93456A225C, (U64)0xC649DF0012105267, (U64)0x5BF66457976959B9, (U64)0xDB8EAB069A0B5DE4, (U64)0x79D296DDA9FB3BDE, (U64)0xEDAE95A4E16EB61A, (U64)0xCEDED40FD3B64079, (U64)0x9749C4F60960AB19, (U64)0xBD5A632CEF5DA45E, (U64)0xB5F9313F7B0F5065, (U64)0x6CD28DEA3F325BFB, (U64)0xEC32C0F83BD44F24, (U64)0x47A7A612380A5BD, (U64)0xE32A6E194C25A158, (U64)0xC9E03CB171655F79, (U64)0xAEE52E4AC2BF2D5B, (U64)0xA1528A906694BB3F, (U64)0xE8D520E3FDDEC724, (U64)0x3D688475B5F5C4B9, (U64)0xB032294571B7D127, (U64)0x35E1B9C0847A2BF, (U64)0x960386E5C6D2235B, (U64)0xBC40C14CB958F93A, (U64)0xEB9447F76A4C321A, (U64)0xD666724D94C3E97D, (U64)0xDF84C94E15B8D366, (U64)0x647019570EF2B8, (U64)0xA74FD919DD2AD665, (U64)0x72C6E222D09CF6FE, (U64)0xC5F5EF5A3C19350B, (U64)0xE37CA8D0139BEB58, (U64)0x1C1ABE08FC036008, (U64)0xC3CE53F238096F7E, (U64)0x9B2A25F08F639174 },
{ (U64)0x461419A45A49F4DA, (U64)0x56EDF4A607E98014, (U64)0xA7E00A9F76E964FC, (U64)0xF0FD1AC71C0C6A68, (U64)0x72BC416F9EC4FD59, (U64)0x83A539414D0E66B, (U64)0x38D8BE4EB2FE783E, (U64)0xAA0A5C0D25A40E15, (U64)0xB3B8F05AB09267D9, (U64)0x1BF11D1AA5B61216, (U64)0x99D86543BE6A63AE, (U64)0xAFC9F3BBD2F7FCEA, (U64)0x79031926C077A1B, (U64)0x770633291EBDF26B, (U64)0x7D704433D0B5620D, (U64)0xF596B591E0DF18D7, (U64)0xA0A809C728E77999, (U64)0x2C5164E72C450D54, (U64)0xCC7C94FC1435FDCF, (U64)0xAB61DB047BB0FEAB, (U64)0x49A09C2EC6F86619, (U64)0x268ECAC7FD2EED28, (U64)0x68542D8D5962E44F, (U64)0xB6D42ECA180ED4, (U64)0xDD046D7B8A6C3FDA, (U64)0x78798478C60A0B55, (U64)0xBF647C509FF6EBCD, (U64)0x5A7522F8F96B68E9, (U64)0x7C2E75118EBB3458, (U64)0x13BA83FA71E07F6A, (U64)0x1E2CC450B71FF20E, (U64)0x178A28D202418D94, (U64)0x8A26848446BAA8D8, (U64)0x4B4D69C46AD99D17, (U64)0xB28071AD6B09E88E, (U64)0xDDD476D13AC77EB, (U64)0x2F1E1DC52864A33A, (U64)0x5C122F06DBB3796B, (U64)0x3A030EC2F9CE70C, (U64)0x6F2AC16FA8F693F7, (U64)0xBE1A7D38ECF1BA39, (U64)0x16C51039783C8E74, (U64)0xC5A98812414A7E4E, (U64)0x30F9AFD38FD7738A, (U64)0x1AB2EC78A115A5B9, (U64)0x4824DE99034C6E09, (U64)0x709159538D4365CE, (U64)0x2A34A8501C3D85F5, (U64)0xF79A15856706A47B, (U64)0xE1B3F887922788F4, (U64)0xD1BF614E8997604D, (U64)0x6783463EA512E188, (U64)0x458201964B92BBF9, (U64)0xBB6CB725A18FF4CB, (U64)0x353FB0AF47007BAF, (U64)0x1DD4188CD66A02B4, (U64)0x60A6B85A074D2278, (U64)0xE41B113A1BE016B7, (U64)0x201701F32B64272F, (U64)0x570F3F826449F6CB, (U64)0xB1CE6B2BD14928BA, (U64)0xEEC85BD82CD0F2CA, (U64)0x8A2F4932EEFF2CAD, (U64)0x48F8F5317DA110B6 },
{ (U64)0x15464BE6B9983738, (U64)0x940F64E6FDBB42F5, (U64)0x7F23FC4DA66AB56E, (U64)0x1A3FD33DCEFFB08B, (U64)0xB06E9297750E2EA8, (U64)0xD1F0A0674631A588, (U64)0xDE036D8DA0BCAAEE, (U64)0x57E89ECFFDD64EF4, (U64)0x425A239B7163254A, (U64)0xCB27CED9754CC1F4, (U64)0x7A8B95B04CB9A36C, (U64)0xED9330E0003C2E88, (U64)0xC7507B48BFF5B8C9, (U64)0x9474C1DBEC6E33EB, (U64)0xAFA384610061B8AE, (U64)0xA7446672931FC895, (U64)0x7A78CE25D364A349, (U64)0xFE832735DF87D796, (U64)0xD9F7D2CD6F6A52E, (U64)0xF883295CA8633DEA, (U64)0x9AD87FF596B2A3CB, (U64)0xA44C29063CED31EB, (U64)0xB89FED5EBA92A7AD, (U64)0xE27487CE0BC8DD97, (U64)0x3FD0379858BFBC09, (U64)0xA99B4E8A05D2C9D4, (U64)0x1DF78C93F605180F, (U64)0x8BAFC1233AA03B2B, (U64)0xADEC86495C6BE588, (U64)0xF36AD4B892322FA8, (U64)0xC55F15A2709501CF, (U64)0xDDDAEA11E1F74F54, (U64)0x8C45644B4F8EA0A, (U64)0xA035BA3720394ED5, (U64)0x6053E16F38C80A4D, (U64)0xD70D2C9FD3DDAD29, (U64)0xFDC46FB6F89C73C8, (U64)0x8ED2FD051B41B8AA, (U64)0xC261F83FD54E17CE, (U64)0x88CA13AD62344914, (U64)0x5D6CBEFBAE036848, (U64)0x540553EBEA6F5C97, (U64)0x37494BD2919B0C0E, (U64)0xE0315D22F91EB66B, (U64)0x7070068A629667CA, (U64)0x19D61479F98EBCFB, (U64)0x32419B815F09848C, (U64)0xBBA6FB00CE6B5607, (U64)0xA25843574EC67F21, (U64)0x3693A5442E44A84, (U64)0x82E5B26D5B649B0E, (U64)0xA5F1B4FC3DC1B01A, (U64)0x779F257884164A1, (U64)0x683EE4C6F3DFAE99, (U64)0x67DD637C37F2824E, (U64)0xEF06D2FF04A8C065, (U64)0xB2316AAAC49D61A3, (U64)0x36F9C3E8C833CDE4, (U64)0xC9D5D3B9F92785CD, (U64)0xB4CD584197F22618, (U64)0x529F1BE9290AFA65, (U64)0x250A89121F38319B, (U64)0x78FD8AC0AD37DC5F, (U64)0x901A27C3AC55C224 },
{ (U64)0xC7A782156F6AE7E4, (U64)0x69D52F153C48D327, (U64)0xBDF93F8465B8C7BF, (U64)0x4BED21FD0D3D325B, (U64)0x61A7725427FDEC66, (U64)0x130360BF85E3775A, (U64)0xD51877F496C483D, (U64)0x15B3CF1EBE169526, (U64)0x888F6389A329F5A4, (U64)0x58742EAB968D8125, (U64)0xAA69C66A8F7B50BE, (U64)0x1F70C002E46E715B, (U64)0x3DA38AA8CF34EB24, (U64)0x46B7980024E4E118, (U64)0xE6176A2C39A5B7E, (U64)0x6485A6A053C80B64, (U64)0xBD2B1E7401B662A6, (U64)0x1D6AD7B69DD60764, (U64)0xDF45AFD7AE0446FC, (U64)0x285228BF62A3EF18, (U64)0xA1BEF3755637945, (U64)0x559DF9FCEE3FF21B, (U64)0x722F9E1E68D15D7E, (U64)0x33AD4F1DF9BB0D65, (U64)0xEE33F44A997564C5, (U64)0x6B4A3F4A7D31120E, (U64)0xC6A7466B64C55CBE, (U64)0x61FA1523CA50F972, (U64)0x4F3F448BB79C6747, (U64)0xA82914614448F473, (U64)0x259FF3A1A046C33D, (U64)0xF393BE13B3C1F0F, (U64)0xFA1F9DB7F30838C5, (U64)0xF6F650F5F3EA080C, (U64)0x31BBB2B4CA9ADABF, (U64)0x54CEFECC801F7E73, (U64)0xBE87BC663ADF2004, (U64)0xEF216EDFC8814A30, (U64)0x90B30ADD068DD41F, (U64)0x5811D07E93E7A8CC, (U64)0x5AF6C2B56CBAB86, (U64)0x85D6A1081BEDAE4D, (U64)0x759B9B085269CDDD, (U64)0x38696F02ACC4CB1, (U64)0xA181D5D99040B604, (U64)0xDB45C722AA565D32, (U64)0xC123E2601EF8D65E, (U64)0x59F539C20DA2AECC, (U64)0x408180949C95ADC4, (U64)0xD00AC9948116B94F, (U64)0x622772B5B0AE59DE, (U64)0x7732670DFFB352F3, (U64)0xD5E938655883A456, (U64)0x8AFD2E9E133C5F73, (U64)0xBE0F83BEF433401C, (U64)0xA4ED613FE459B28F, (U64)0x7151C9683666BBD5, (U64)0xEF2A242B2243AF0C, (U64)0x1F279A4A39B55B9E, (U64)0xEC1A8A935530D5F2, (U64)0x825DC9387AFEA235, (U64)0xB5F14AE1D9EBC971, (U64)0xBA2E7E1357645F1E, (U64)0xF3CBCC80E61E21ED },
{ (U64)0x267D70D5AEA904B7, (U64)0xAB04DDC7EE882D6C, (U64)0x4E9AEFF6937204DD, (U64)0x998CE32EDDEFC390, (U64)0xBB55A186A63D1D35, (U64)0xE043B37D7DA0D713, (U64)0xCD9094AF9B9F19DF, (U64)0xC7732D3C0CC527EC, (U64)0x1A5D996A48BA0674, (U64)0xBA94BC7AC45F726F, (U64)0x79B8046BDF0B925F, (U64)0xDCA41BD23FAE91D3, (U64)0xFEE1487B0D6209F6, (U64)0x976F5AC0F7179252, (U64)0xDC98BD5031588BBD, (U64)0x94775469803271AE, (U64)0x4DC1FDBEC1571074, (U64)0xCDB814C40C3CE4AD, (U64)0x35C0EC157DCC943E, (U64)0xEB80FA6D93501FD3, (U64)0xE9C9B5C78F918BB4, (U64)0x1F5F333F1DCA00D0, (U64)0xA16C4CCDA9439DBE, (U64)0xA94FBCD72A39EEAC, (U64)0xBCE10403EB048736, (U64)0x1008E919AEE3F2EC, (U64)0x824495A8A716877C, (U64)0xB73897D5C9130890, (U64)0x1DFD957C67569CB5, (U64)0x6AD3C78384891693, (U64)0x764420714BA69AFE, (U64)0xEEEB513AFBECFCFD, (U64)0xB15FED2D21CB8555, (U64)0x2724802533A0F1FE, (U64)0xD36C78540E61197E, (U64)0xA4342F0862CC1CA2, (U64)0x42777CA0C90DC2D7, (U64)0x3DF32E3EA25609E3, (U64)0x7250C98E46FD06BD, (U64)0x9B93208651A7FA9F, (U64)0xC67F85D08518DB55, (U64)0x677468DAD91D6F9C, (U64)0xA6D839CB88AA1F3F, (U64)0xD144C6B7E23F8EE3, (U64)0x7353911D51A84496, (U64)0x80F27E06A358FE0, (U64)0x9F83032AC3A14AF, (U64)0xB15C8395B506D9C, (U64)0x9223706C5F674D16, (U64)0x12DA99677BCE79DD, (U64)0xB9D0817760FD080D, (U64)0x1EEAAF8B0C7889A1, (U64)0x36ABEBA233F35794, (U64)0x530DDF5DC0EA9DA2, (U64)0x5CDE514F26E193CE, (U64)0x743D25E5BF9B775C, (U64)0xA1839BB3F6A45816, (U64)0xDFAF4DBF3807DDF, (U64)0xCDE6689ACA549A4E, (U64)0x2BFA4B7684E19723, (U64)0x1A7025EB83541D6, (U64)0x573132F10A298AA3, (U64)0x6B66BDD1869685CC, (U64)0x21091E5815CCF11F },
{ (U64)0xFCAFB30F74FB5A55, (U64)0x78661E049D53EE9C, (U64)0xCE4E052590839C0E, (U64)0x7B56B0C82EA60162, (U64)0x5D96E3E350EEDFD7, (U64)0x2291510EAF140CE1, (U64)0x3E62446C5855DF8E, (U64)0x681FEE7CC37E71D, (U64)0xFB3E4AB2985AC437, (U64)0xEB4EE7B8043CF0BC, (U64)0xBB7AF59935C8C20D, (U64)0xC76D9157D5D0200, (U64)0x2E3A9FBDDE99D8B5, (U64)0xF58DA93235C75283, (U64)0x861A2D90F10858CF, (U64)0x5FB5171B6672B27C, (U64)0xE10AF4DB285D336, (U64)0x977AC605E6EFB6FF, (U64)0x64B21C44BF1F574F, (U64)0x114A31A9D19A5403, (U64)0xBB2876107E52CA76, (U64)0xC82D40EFDD88C082, (U64)0xC1BE852F73AB4E4D, (U64)0x4B1C6AA6E2E9303E, (U64)0x5E20C6D168C655F4, (U64)0xD0D32AFB6C2221BD, (U64)0x719671FA576055A6, (U64)0x66CBC4061BC1CA43, (U64)0xC4849FACA4075C76, (U64)0x9B042D50FF5BC7C0, (U64)0xB4A6609219755826, (U64)0x3C2883F8082F2E3C, (U64)0x618C3E6CC91947B6, (U64)0xE5C5C346C411333C, (U64)0x1AE8B87DDA343A4, (U64)0xE7B5CDFABB36CD40, (U64)0x81A48E530FAC5A35, (U64)0xEF72DCEC33BCD303, (U64)0xA3001B46B536FB66, (U64)0xE9626B450254397D, (U64)0x349C5792476A18A7, (U64)0xB42DBAD20ACE357E, (U64)0x4E206A3B797EFCE6, (U64)0x9215246731FFDF02, (U64)0xB1D862CF4B7B0747, (U64)0xE0FA341199E74903, (U64)0xDE28F3F96FE9E565, (U64)0xD2C61AF9EB93BF5F, (U64)0x370BAAFAFA59EC5, (U64)0xAB0953BDAB8DAA1C, (U64)0x7B104384235DFAA7, (U64)0xCC095CD8CCE84963, (U64)0xE6580B72E1309546, (U64)0x95CE198F02224E60, (U64)0xCE1C1A55CE9AF327, (U64)0x97FEF7067DC8AD1C, (U64)0x4A504A5325748886, (U64)0xDF113700F152BC1D, (U64)0x2CBCBF58888268A5, (U64)0xD929B12466234F61, (U64)0xFB64F28D49E79304, (U64)0x466E032E2595822, (U64)0xB9946FA844577706, (U64)0xE2729F9AD53DB25C },
{ (U64)0x3E4E23CC07529B86, (U64)0x18B5CEFC5BB1BE5F, (U64)0x1D8C56E548C17FC6, (U64)0xAA8550196454D223, (U64)0xCC61A31931C8406, (U64)0x737280CE6CCFCE23, (U64)0x74A08696AE846444, (U64)0xF44226251FFE34DF, (U64)0xA9E68A70DA891DC5, (U64)0x218D2763FFEE285C, (U64)0xC0C03F5AE61E39C6, (U64)0xA7B528E78C9FC0E2, (U64)0x4DDA7F8C36591E47, (U64)0x2F5A69714404CD61, (U64)0x63496E4BA2AB3A06, (U64)0x896EC7C8BDE1229D, (U64)0xDCD2649F70CE03E7, (U64)0x742B6FDF352F370C, (U64)0xB661CEA66EEDA785, (U64)0xD03BC17A064886F0, (U64)0x70FA8452BC821825, (U64)0x28FC94CD8E539353, (U64)0x125D77F74078AC07, (U64)0x9ADCAB74300271EC, (U64)0x877A1522B01517A6, (U64)0x333DA229C50736F, (U64)0xB35F221B94A0B5C7, (U64)0x40B2EC6EB351193, (U64)0x26526C6FD6E58F26, (U64)0x59C4FE902DB80512, (U64)0x47779A48D937AB45, (U64)0x6F9040CB5A5DF7EE, (U64)0xB26EFC9E1AE294E4, (U64)0x1757319C06C3E16D, (U64)0xC0DF4B853773A2D6, (U64)0x35675E3979F60BD3, (U64)0x13664593567E99E6, (U64)0x4C08172FF1ED0250, (U64)0x79D37AB573E4B9B6, (U64)0x2030B917E29EE9AC, (U64)0xF706104194AB8266, (U64)0x6CFF5921620CF62C, (U64)0xDDE3B2E83B152434, (U64)0x6AF7F785D3A80DD0, (U64)0x40AEB02CB8B9DBA5, (U64)0x3338E6C35B2610D3, (U64)0x3CCB0329B71927B6, (U64)0x340CD12A2043FDAD, (U64)0xE1A069FD6D7CDC27, (U64)0x69EBA0FDE85F50EE, (U64)0xAAC3D254D18E3876, (U64)0x1FDB1A381B0BBA92, (U64)0x3D98599021E245A7, (U64)0xE714CA7EDBD1AE93, (U64)0xF67EA961D5A20F5, (U64)0x450C34D48C305EEF, (U64)0x9CB880404F175B45, (U64)0x9C434D4202B84EEC, (U64)0x7E7F7FAB51492B77, (U64)0x187B63EF3DD4ACB3, (U64)0xBAB031458B1752C6, (U64)0xD48423C031DAA8F0, (U64)0xDA57846A978536B7, (U64)0x52B0CD6906FF488C },
{ (U64)0x4F1C613E87804946, (U64)0xCB772C3F8BE15D8D, (U64)0x777F8437BB12AD35, (U64)0x68658353F497AEF1, (U64)0xCE24C8FA495C5684, (U64)0x99AACA1D1E0DBDF2, (U64)0xA53B75D7FEE6A4B6, (U64)0x2F92C4D5EDACD68C, (U64)0x7A247D832D4B5F06, (U64)0xD75DD4832D27DBCF, (U64)0x91EC8A26E7BB56, (U64)0x754D6AFE5E4A30B3, (U64)0x9F0C2D56E58AE486, (U64)0xEE0ABBA1C6562FB3, (U64)0xB1A99C694879E2D4, (U64)0xE82E2C0A7D03D1CF, (U64)0x3500945FA91CF805, (U64)0xA4C93D3CF5DCCDCC, (U64)0x55A105758CACE056, (U64)0x82F91780C43927B2, (U64)0xA0A845ABEF69FBC7, (U64)0xFB36571E64B329F1, (U64)0xC085F03480BA7DD6, (U64)0xD82ED9B713D0830D, (U64)0x41997DE043E1E657, (U64)0xA1E110E05FDB928C, (U64)0x62ADE0C94E7B6615, (U64)0xD791FF3D20FE6370, (U64)0xF591BC150676FDF5, (U64)0x8B76BEE2EC6876F3, (U64)0xCF2549882AE56997, (U64)0x8D46B00B9B9D150C, (U64)0x50BF0D5DD8A2F436, (U64)0xDE05E05D5D0010AF, (U64)0x3E1D997466907017, (U64)0xDC0516E18A25F113, (U64)0xF2DF5508B4B56BB6, (U64)0x94CAC7DF062FE092, (U64)0xBA39A867A8146BD5, (U64)0xF2F258F4394E0A6E, (U64)0x2757E0A1707D7234, (U64)0xB1C09F3B05706ED, (U64)0xF3171AAA8876756, (U64)0xA82C275E8302EE13, (U64)0x8A6F79F478E878F6, (U64)0x61EB2F008BD4F290, (U64)0xED19C1DB455AFCD6, (U64)0xE7FBA148F2300C2C, (U64)0xBA430B3E369E2776, (U64)0x3B30640E1ABE12AC, (U64)0xC8819817014CE5B4, (U64)0xBD0ACBE269D9F850, (U64)0x5F438A4BD21B3E75, (U64)0x2675CABC299375D3, (U64)0x7DA53D66DF89E236, (U64)0x944DC4D55EF39E2D, (U64)0xCD6B73829E81B9B7, (U64)0x6C829E92C26989AE, (U64)0xBD8F8D6B9319FBB6, (U64)0xCA92201FFD9C7E12, (U64)0x68D3E3B750D4A037, (U64)0x3755D10173086B13, (U64)0x87D4B9B76EE475, (U64)0x98652EBBC42C886F },
{ (U64)0x8DDF926F5442ABB5, (U64)0x118E7F2D60228F6D, (U64)0xA2EF65D479E2EDF7, (U64)0x97B6498017476D03, (U64)0x3DFF0B2AB987B75E, (U64)0x4B7939FFDBDD7D00, (U64)0x475BBD0535357777, (U64)0x6F515706A40F8F5C, (U64)0x98D7FFD1FF1FACDE, (U64)0x163E16D1ECD5991D, (U64)0xD2538C68D12568B5, (U64)0x240EB93C9DB0F361, (U64)0x46DFE695A768A55C, (U64)0x5CC950621DBEFE62, (U64)0x727B4DB899B26136, (U64)0x3AD9FEFA0ED0131C, (U64)0xE76346AC6BEC3A9E, (U64)0x6712EAEC079E0E1F, (U64)0xC75BF5BD577E3AA6, (U64)0x602AD4C13CFBF562, (U64)0x426197694F3B231E, (U64)0x29C5A5D6B460E823, (U64)0x2153A04653EB2744, (U64)0x2BBD1365C591015F, (U64)0xF249AE308122209D, (U64)0x7262831305090C5C, (U64)0xB8EF19023E99A4C6, (U64)0x17723D7FF22CA222, (U64)0x37617ED4CDB63D1F, (U64)0x62354C393E23B621, (U64)0x1DC78BFFF81CB846, (U64)0x540563D8694E465D, (U64)0x813DC78F297127DF, (U64)0x8CEE2A8BEDD4521C, (U64)0xFDC6FAAEA4C2A3C5, (U64)0xAD4C402DA4730E0, (U64)0x209D926A6765285D, (U64)0xD71B2485C4DC3262, (U64)0xCAEE73A368D7AA07, (U64)0x500B8A24FBBDD09C, (U64)0x4DB532726B96B1FE, (U64)0xD9CCCB3673B7C51F, (U64)0x6EF083534E47B587, (U64)0x7BFC8C9E00D236E3, (U64)0xDDBDCBB7AA1AAA3E, (U64)0x820BDD38601F2142, (U64)0xBF58921C8680AC05, (U64)0x273B639B13F2CAF6, (U64)0x7A99DACEC6CDA7BC, (U64)0xDA70B7C8DB68C375, (U64)0x1A786BCDCA9C07C6, (U64)0x6C682921A219288B, (U64)0x8EA1628B00D9FC3E, (U64)0xF4A738672A023708, (U64)0xB670FFA0AE6B1846, (U64)0x76971F279921CDF5, (U64)0x2F29B3715C48E4FE, (U64)0xA7705E75192B5174, (U64)0x455C067060EA00C4, (U64)0x9040D0CD2F4FBDCC, (U64)0x8A0182641086637D, (U64)0xED8750DB83F1B14F, (U64)0xC124165D6C3C0726, (U64)0xCBA7FEFABC465BB1 },
{ (U64)0x5E254AADB6937A7F, (U64)0xB04CB7C9B2D44F32, (U64)0x70A4B78CA9211E26, (U64)0xD774B870C5B4BFCE, (U64)0xF52FFFD8FA6565BF, (U64)0x9A3BE92601BEAE4F, (U64)0xD58C6EC2C7B505A5, (U64)0x9C2B17C476DF4DF3, (U64)0x4117AE1036E46C3D, (U64)0xC4ECC7163E174871, (U64)0x31A05EB383768867, (U64)0xC6DC51CF6DF3A98F, (U64)0xE09F146550BA77AE, (U64)0x9F330098ED6DBC8C, (U64)0xA2A8877E5B6293E7, (U64)0xE80B2B39DC184EF0, (U64)0x35BB85AE982F684E, (U64)0x95D02AAA544ADCF1, (U64)0x698324F57958B65, (U64)0xB388A413FF2836AD, (U64)0x9193FCBA95BBE0CC, (U64)0x68456C2577A23AEE, (U64)0xFB306293B11DC4A6, (U64)0xE375C0850443D090, (U64)0x328B7C53D178FB4E, (U64)0x2A12C107E4F9CE93, (U64)0x5A3ECBD2FD48DD26, (U64)0xAC22CEAE93CD30EE, (U64)0x46E38D063F65E68E, (U64)0x34ED9FF9DDD12DEF, (U64)0x7E1E3A2D31DE4EA4, (U64)0x96F5293AA2B48693, (U64)0xC347946F7B93E50D, (U64)0x6F3AD9782EBF89D0, (U64)0xAD262A6D574B4346, (U64)0xD806271018D662AE, (U64)0x7A4F60BBA716F88F, (U64)0x25F976469C1C77AD, (U64)0x92E93901B8158C6, (U64)0x81C949EF2BFF02D1, (U64)0x9E67F9B8A946E34F, (U64)0x180E30C4856417D0, (U64)0xBC82429196B45745, (U64)0x9B1EDEEDFA11F5AC, (U64)0x3D5E89454DD96ACD, (U64)0x52511EFA324FF1EE, (U64)0x5D827ACCD4624FC7, (U64)0xF469B453C1281190, (U64)0x895A1815054D744E, (U64)0x886D51901A30193, (U64)0xC1AABF2C38E75407, (U64)0x26B2FBD1724AF36F, (U64)0x4CF0B1F8490A6DEE, (U64)0x5F75E307FAF0E7FE, (U64)0x62920E737CBFD985, (U64)0x2C755DFCEBC10F02, (U64)0xFDD8E1A98FBA262C, (U64)0x75B2ACA7EBD802A1, (U64)0x86DE5492A028C206, (U64)0x7183130EDCBDED1F, (U64)0x59D05064A36D39AE, (U64)0x284C02B85033729C, (U64)0x337EE58FAEFCDBC6, (U64)0x2B5434003FD6A961 },
{ (U64)0xF6E489566EE1A02E, (U64)0x621B441AF31DB4E0, (U64)0xB2567C4FCAFBDC54, (U64)0x42FEAB204765F1C, (U64)0x26EC3D1B28B4A3ED, (U64)0x78CA2BE4C26C509F, (U64)0x65E0C320642C5D6, (U64)0x5EFAC4BD951CBE21, (U64)0x834464CAC426BF6F, (U64)0x172DADE619C6AAA2, (U64)0xE1628DF14896DB37, (U64)0x143D830FA623585E, (U64)0x3264C5A780F3A4EF, (U64)0xCDF2D74B2FAF4EDF, (U64)0x4940748D8C9152B5, (U64)0x98A29231C4BAC23, (U64)0xD6783577D8FDA9AD, (U64)0xDC65D8799CF1ADA1, (U64)0x7C48605CA54549B7, (U64)0x6B516FF0EDC04C1F, (U64)0xC1502C5A5648B22E, (U64)0x9216BEF785D0D99C, (U64)0xBDE0915169DE5677, (U64)0x3406205EFEB42A60, (U64)0x61389D8932980BAE, (U64)0xC8C130C5363A3F61, (U64)0xBDC09202F0A1FF5, (U64)0x6EF11E6C459FD21D, (U64)0x8C3845C5FE9F044C, (U64)0xE70E570A8511DF1E, (U64)0xAEDC78EC430D0476, (U64)0x6436D8E272773540, (U64)0x3D907034B0431DCE, (U64)0xBFF95938FC6D2903, (U64)0x4EF4E19F87B998B6, (U64)0x19EDF7D1EB1C917E, (U64)0x9BAEB17974D4074E, (U64)0xE42AB7946FCF8D7F, (U64)0xDBFC415299689B34, (U64)0xD31AB11DD82A6303, (U64)0x4EA60B885905028D, (U64)0xEA75E00754A66702, (U64)0x76501042556686B6, (U64)0xC84D1F3F3BC3077E, (U64)0xEE865A941703190F, (U64)0x9082CA29F3FC123D, (U64)0x8460A9AF31B39D5F, (U64)0x9E8A548082C9E143, (U64)0x4BAEE3D7D3BE868F, (U64)0xD34504FBC253F240, (U64)0x21697DFEF92594DD, (U64)0xD571608291B0113C, (U64)0xFE22332ABB6A8F4D, (U64)0x8F9421D5183B043C, (U64)0xB1014413B7748B5F, (U64)0xE9A4AE3C2396F740, (U64)0x3C1A026A7F6994CE, (U64)0x946B6F6EAB18E003, (U64)0x14259541F2F812DF, (U64)0xA353C13E1A7D0A7D, (U64)0x813A8B9761BDC85E, (U64)0xFA3CC96A9A60027E, (U64)0xF1AF35045E4F1819, (U64)0xF804C7C3ED15E802 },
{ (U64)0x21327F96AD22C3FC, (U64)0x20DB96D001CF7603, (U64)0x43976CBD109B079A, (U64)0xE6CF29617E2E8CFF, (U64)0xC41E6E4BC9765A3E, (U64)0x2B0898D732A7915C, (U64)0xE6BFDDE8D4981E1A, (U64)0x8D382E7F45CA7CE3, (U64)0xD186962987F74DBE, (U64)0x77D77E3DC3B47160, (U64)0xBABB6520B8451DD8, (U64)0xDDEF44DDF4C09A9C, (U64)0x73A607F44B41443D, (U64)0x2460350BFC5E8F1D, (U64)0x1B93B4557ED3005A, (U64)0x9370DAC2CFB97EE1, (U64)0x868E7E954E945BFF, (U64)0xA3713816F336F62, (U64)0xBE2B819E66869BDB, (U64)0x8807BD201C138DDC, (U64)0x22C0EE88A69E527F, (U64)0x50F4DC34D419895F, (U64)0x4C234BAA2A069739, (U64)0xE6C4B31C3D7469A3, (U64)0x8BE84F48E84B48FD, (U64)0x1B0BE23EF5E8FD23, (U64)0xC907FA63CEB98CBB, (U64)0xBF13549F861C0FDF, (U64)0x5E5816352CDDD73E, (U64)0x7DCA4C806C21D5C, (U64)0x7D0FAB3680EDD5BB, (U64)0x25EC1AA11027F7E2, (U64)0xFC50A2F66088DE3E, (U64)0x6C0B0BE21CADFA61, (U64)0x9C2713DF4C6ADA79, (U64)0x6B3B342323CF119D, (U64)0x497C7B8A4600C5BC, (U64)0x36784D75ADB50E1C, (U64)0x309FC28B49BA43FA, (U64)0x307AE3CDDAC0B1F0, (U64)0xED5C4A5B9AB7D85E, (U64)0x60B5235F9E56ACF3, (U64)0xA39BFBA0A725587A, (U64)0x128DC9FEE9B247AC, (U64)0x3C549A56D6E3DBDE, (U64)0x6B62A8CB253E48EF, (U64)0x6B17F75EB715DB8, (U64)0x4F5287727A1B2293, (U64)0x98EC33A73064C75D, (U64)0x1795DEE0F2103692, (U64)0xF2D98E3DAFF4473A, (U64)0x158520404371C2EE, (U64)0x37C062EB78BD5C9F, (U64)0x5C4ED016C3E9D6ED, (U64)0x53D196C8670658AB, (U64)0x1B766ECEF05C3493, (U64)0xC6C0D298B529551F, (U64)0xC6293F9C78CB30D0, (U64)0xF765678141135149, (U64)0x603128FD4BAED0AC, (U64)0x42E96B55B17E4A9D, (U64)0x98FE39AA6BA0C1AC, (U64)0xA04DFE749D9DEACB, (U64)0x2ACE97131EE732D0 }
};
#else
U64 zobrist_Tablero[14][64] = {
{ (U64)0xDDDFD6AE, (U64)0x5BAAF5DA, (U64)0xAEAB7BB6, (U64)0x5BBAD557, (U64)0x56D7D6AA, (U64)0xAB76BB6A, (U64)0x6DAEBAD6, (U64)0xAAAEEEBA, (U64)0x6EAFAF6A, (U64)0x7BAD6FB5, (U64)0xB5EF6EAA, (U64)0xDDB76FBB, (U64)0xD5DFD55E, (U64)0x7DBD556A, (U64)0xFB56EDFD, (U64)0xBF7D5D5D, (U64)0xB7F756DA, (U64)0xD56D6ADA, (U64)0xDF5B56D6, (U64)0xBBDB6DD5, (U64)0x5B55DFBE, (U64)0xFFD6ABBA, (U64)0xEBFD7BD5, (U64)0xFADB75EF, (U64)0x576ADBDB, (U64)0xF5F55F5D, (U64)0x75B7AD5B, (U64)0xFAEF755D, (U64)0xDDB5F57B, (U64)0xD756D75E, (U64)0x6BADEDBA, (U64)0xBAFED5AD, (U64)0xAD55EF7A, (U64)0xAFDAEAD5, (U64)0xD6D5FDAD, (U64)0xBD6FD76E, (U64)0xBBAD756D, (U64)0x6D7B575D, (U64)0xFD6F5BAB, (U64)0xAFADADAA, (U64)0x7F6AB6D6, (U64)0x75ED5EEA, (U64)0x56F77D7A, (U64)0x5F5FDAB5, (U64)0xD5F6AF5D, (U64)0xEAB6AD5A, (U64)0x55B5AB6A, (U64)0xEABAFBB6, (U64)0xAED556AE, (U64)0xDD7FEBDA, (U64)0xABF55F5A, (U64)0xAAD7BAFA, (U64)0xBEBD6BDF, (U64)0x57ABAB6A, (U64)0xBBFD755A, (U64)0xFB55FD7B, (U64)0xAAB55575, (U64)0x5F6FD7ED, (U64)0xFEEFBADA, (U64)0xB5DBBB6F, (U64)0x75B76BAD, (U64)0xEBAEAEF7, (U64)0xAAABF7F5, (U64)0xEFF75D6A},
{ (U64)0x55AB6D75, (U64)0xDBBF5AAA, (U64)0xFBEAEBAB, (U64)0x5D56FDAA, (U64)0x56AAB6B6, (U64)0xADDEEFF5, (U64)0x557FDF5A, (U64)0xAAED5DED, (U64)0xAEAB6EF6, (U64)0x75D6B55B, (U64)0xAD7EBEDA, (U64)0xD5ED55FD, (U64)0xD575BAAA, (U64)0xDBBADEDB, (U64)0xBEEEAB6E, (U64)0xAD76AADD, (U64)0x55DFBBB7, (U64)0xBB6AB55A, (U64)0xDEF755BD, (U64)0xB6B5DAF5, (U64)0xEF5DD56A, (U64)0xADD5BDBA, (U64)0xB6DD756B, (U64)0xBB5BBEAA, (U64)0xAB5555EA, (U64)0xAD556EEA, (U64)0xB6F75D6A, (U64)0xDB55D557, (U64)0x6DD6F6BA, (U64)0x5EB56DB6, (U64)0xF7776ADE, (U64)0xEFD5DBAD, (U64)0xD5AEAAAB, (U64)0xAEAAD6AF, (U64)0xDAB6DEEB, (U64)0xD7AAD55D, (U64)0xAB75FB6B, (U64)0xD6DDBBD5, (U64)0x55ADAD7A, (U64)0x555AAAEA, (U64)0xDDBD6D7D, (U64)0xADAD556A, (U64)0x5556DD6B, (U64)0xD6EBDF76, (U64)0xDDBBAADB, (U64)0x56AD7BD6, (U64)0x5DB5BEBB, (U64)0x5EABBFFB, (U64)0x75EF5D6B, (U64)0xD55ED6AD, (U64)0xD575B6EA, (U64)0xBEDBED6B, (U64)0x75F56FDE, (U64)0xADED7D56, (U64)0x5EB56DFD, (U64)0x55D76AAA, (U64)0xF557BF7D, (U64)0x6AFDFAAB, (U64)0xD6ADD775, (U64)0xBB755AFF, (U64)0xDF6DDAD7, (U64)0x55DD75DB, (U64)0xDABD6B76, (U64)0xFAAEAF56 },
{ (U64)0x5AB5AAF6, (U64)0xDAB5AADB, (U64)0xDEBEF7D6, (U64)0xD5EBBB6D, (U64)0xB5F5DAD6, (U64)0x6DFAD57E, (U64)0xBB6DAEAB, (U64)0xAEDAB6D6, (U64)0xAD5DBEEA, (U64)0xAAFB7FB6, (U64)0xADEF5AD7, (U64)0xB5BD5D55, (U64)0xABDD7DBE, (U64)0xBF56D6DE, (U64)0xADFABEDD, (U64)0x5AEDBDD6, (U64)0xF6ADEBFA, (U64)0xF56ABEEE, (U64)0xAAABD755, (U64)0xEBEB7D75, (U64)0xAD55ADDF, (U64)0x5DB76F6D, (U64)0xAD75FB7A, (U64)0x6AADDBBA, (U64)0xF7ABFBDA, (U64)0x76DD55AE, (U64)0xF5AAAD77, (U64)0xEFFBB5AE, (U64)0x556BDAED, (U64)0xEFBFAAF5, (U64)0xAF575BDD, (U64)0x5DBAEBAB, (U64)0xD757DABD, (U64)0xBB55D576, (U64)0xAB5EF76D, (U64)0xFDDAABB7, (U64)0x55EEBBF6, (U64)0xEBDFF555, (U64)0x7EBBD7EA, (U64)0xEB55ADAD, (U64)0x5AFEEBAE, (U64)0xEAABAEAD, (U64)0xF7AEB76B, (U64)0xAAEBDAEA, (U64)0xB5AD5BDA, (U64)0xADEEBADD, (U64)0x7AD77D5D, (U64)0xFB756ADF, (U64)0xDB5B5BEA, (U64)0xBD6B5BFB, (U64)0x576FBF55, (U64)0xFAEF5555, (U64)0x7B5ABDAE, (U64)0xEFB5ABFD, (U64)0xBBD6D6AA, (U64)0xD5AAB5FB, (U64)0xAAFBAAED, (U64)0xDFEF55B5, (U64)0x5BEB5ADA, (U64)0xEDD557DE, (U64)0xF75BDDF6, (U64)0xB6EAD5BD, (U64)0x7DB6AABA, (U64)0xBDDEB5D5 },
{ (U64)0x55D6BD5D, (U64)0x6D5DAEAA, (U64)0x6B5B57BD, (U64)0xDB7AB557, (U64)0xFF77EEAA, (U64)0xDDB5DEAA, (U64)0xD57D7AD6, (U64)0xB6BAB555, (U64)0xF75DDEAA, (U64)0xF5D6B6AB, (U64)0xEEAADB7E, (U64)0x5D76F555, (U64)0xEDAAABFD, (U64)0x7ED7775A, (U64)0xED7B7AAA, (U64)0xFD6AEADE, (U64)0xBBB7ABEA, (U64)0xDAAF6BD6, (U64)0xBD6D5555, (U64)0xD75D7F57, (U64)0x77EABF6F, (U64)0xB6B6ABD7, (U64)0x756BAEBB, (U64)0xDB75B55B, (U64)0xADB57AFB, (U64)0xB5FBEBB7, (U64)0x57AEEDB5, (U64)0xBF6EAAD6, (U64)0xAB556AAA, (U64)0xB7BADF5E, (U64)0x5DBDEAFE, (U64)0xAB57B5AB, (U64)0x7BF556AA, (U64)0x6D7AB76A, (U64)0xAD6B6EDA, (U64)0xAD56AAD6, (U64)0xB56BAAD5, (U64)0x6B7EDBD6, (U64)0xDDBBBD7A, (U64)0xD7B6ED7A, (U64)0xF75B6FD5, (U64)0x76B5D5EF, (U64)0x55AD5AD5, (U64)0xD7D5F557, (U64)0xEDFEBB6E, (U64)0xB6B7B5DA, (U64)0x5AAD557A, (U64)0xF5FDBDD6, (U64)0x7B7EFDD7, (U64)0xBDEDDB56, (U64)0xBD56DB6F, (U64)0x5BB5AAF5, (U64)0xDD5B7FDD, (U64)0x6AAFABFE, (U64)0xAAB5B5D7, (U64)0x6BD6B5AA, (U64)0xAB575BFA, (U64)0xB6D557AE, (U64)0x6BBBABEA, (U64)0xAABD6D5B, (U64)0xAD5756EB, (U64)0xAAED56FA, (U64)0xEAB76FB5, (U64)0x55D6B55D },
{ (U64)0xB5EF7EB6, (U64)0xAB5F576A, (U64)0xF6D5ADBA, (U64)0xDFAEB7AB, (U64)0xD55DBED7, (U64)0xABD6AEFE, (U64)0xB5B55D6B, (U64)0xBFEDAFDE, (U64)0xD575B576, (U64)0xDEB5D6AA, (U64)0xAEEEDB75, (U64)0xD56AB6AE, (U64)0xBAFFAADE, (U64)0xDBBF5EBA, (U64)0xBBB775AB, (U64)0xEBDED5DA, (U64)0xDB55FAFE, (U64)0x5EB7AB56, (U64)0xED777557, (U64)0xAFF57BD5, (U64)0xABB77F56, (U64)0xEED5B56B, (U64)0xDAAD5AD6, (U64)0x5ABDB6AE, (U64)0x5EBB6BD6, (U64)0xBB757FAA, (U64)0xBFAAAEDA, (U64)0xAB5557D6, (U64)0xDAADADBE, (U64)0x575B6EAB, (U64)0x5AFEAAEA, (U64)0x55DDD7AA, (U64)0x57ADBBB6, (U64)0x5BAB6F5A, (U64)0xF6BB56EA, (U64)0xAEEADFBA, (U64)0xD6AD5DEA, (U64)0x7AFAF7BA, (U64)0xEB75EFBE, (U64)0x6AD6EEDA, (U64)0xFB55AAAB, (U64)0x56F7BAAB, (U64)0xEF5ED56A, (U64)0xD5AB5DAA, (U64)0xEADD5757, (U64)0xABEF6DB7, (U64)0xEBB6FADA, (U64)0xDED5ABAF, (U64)0x6AEEDB7E, (U64)0xBDB6BDDA, (U64)0xEFDBDEAA, (U64)0xBD6D755D, (U64)0xEF55D6BE, (U64)0x6D5B5F5A, (U64)0xDEADEBBE, (U64)0xDFEBBBDE, (U64)0x7DAD6FAD, (U64)0x555BAF6A, (U64)0xFEEDAD5B, (U64)0xAABD77BA, (U64)0x7EF7F6AB, (U64)0x77F5EAAA, (U64)0xAEFEDF6B, (U64)0xAD76B5EA },
{ (U64)0xAEDD6D6D, (U64)0xBBEBAED5, (U64)0x5D6F5ABE, (U64)0xBDDAAD7A, (U64)0xB6FF6B5B, (U64)0x6DAABDBA, (U64)0xD6FB7AAB, (U64)0xAAED7AAA, (U64)0xEADB6AEA, (U64)0x56AB6ADA, (U64)0xEBAB5D6F, (U64)0x55BD756D, (U64)0x5755DADD, (U64)0xDDD76FBD, (U64)0xAFAB57EE, (U64)0xDD556DEB, (U64)0x5AAD6AFA, (U64)0x6ED6DB5A, (U64)0x55F7B5FB, (U64)0x7F5B7EEB, (U64)0xB6BF7B5E, (U64)0xFAAAD6BD, (U64)0xAFAAEBAA, (U64)0x55EBD557, (U64)0x6B5BAD56, (U64)0xAF5AF555, (U64)0xAAAADD5B, (U64)0x5AAB7B6B, (U64)0xDDB76EAB, (U64)0xDEEFF6F7, (U64)0x5FABB6AB, (U64)0x5B7BADDE, (U64)0x5B555D7A, (U64)0xAB55EDBE, (U64)0x5AB6B56D, (U64)0x6DBDFD5E, (U64)0xB57756EA, (U64)0xD7EBAB5A, (U64)0xAEFEBD5E, (U64)0xFFBD7EBA, (U64)0xBD55DAAA, (U64)0x5BB756AB, (U64)0x5B6EB6BA, (U64)0x7D7EEBF5, (U64)0xB55F5F55, (U64)0xBD7DEAAA, (U64)0x55DF6ED7, (U64)0xB7AD5D56, (U64)0x6FB75D6B, (U64)0xAAAADEEF, (U64)0xF6DED556, (U64)0xEEEB56DB, (U64)0xDDB55D5E, (U64)0xBED75EEA, (U64)0xBDB5FDF7, (U64)0xB6AAEB7A, (U64)0x576F57B6, (U64)0xAEEDAD75, (U64)0x7575FF6E, (U64)0x5F56AB55, (U64)0x5DAB775A, (U64)0x5AFD6ABA, (U64)0x775D7ADB, (U64)0xEEDAB7AB },
{ (U64)0xED75DD6F, (U64)0xBBBADAAD, (U64)0xAAD56DF6, (U64)0xF777FD57, (U64)0xAAB7D77B, (U64)0x5BDF6EAE, (U64)0xAFDB7B5F, (U64)0xF56AD6FE, (U64)0xDD6B75AA, (U64)0xDADB5555, (U64)0x76D7B575, (U64)0x6ADADABA, (U64)0xB75B5EEA, (U64)0x56AAFEB6, (U64)0xF75B55EE, (U64)0x7555AAB6, (U64)0x7BFBDD5A, (U64)0xD55BB6AA, (U64)0xED7AD77A, (U64)0xD6FBD7B6, (U64)0x5577ED56, (U64)0xAD7555FB, (U64)0xB6BBD5BD, (U64)0xADD5EAED, (U64)0xBADB7ED5, (U64)0x76ADDABA, (U64)0x7D5AABAB, (U64)0xB56ABBED, (U64)0xBF77755A, (U64)0x6ABB5D6D, (U64)0xAADB76BB, (U64)0xBFB5B7BA, (U64)0x7ABADD7A, (U64)0xABD6D6AB, (U64)0xAABAAEFA, (U64)0xAEEB7D5A, (U64)0xBDBD5EEB, (U64)0xB75B5AAA, (U64)0xB5AAD6BF, (U64)0xF57EAABA, (U64)0xB6ABFEDD, (U64)0xDD55AADD, (U64)0xB7556BB5, (U64)0xD6ABADED, (U64)0x6D75D55A, (U64)0xB7ABEB76, (U64)0xAAAD55BE, (U64)0xB6AD55FE, (U64)0xAFBBABEA, (U64)0xBAD6AEB6, (U64)0x5755FAEE, (U64)0xAEBEAEAB, (U64)0xD5AAB56B, (U64)0xB7AAED5D, (U64)0xF6B5EB7A, (U64)0xDEED5DAA, (U64)0xBDAB7AAF, (U64)0xD555555D, (U64)0xF75DDD76, (U64)0xEDEBBFB6, (U64)0xED5DBEBE, (U64)0x755FB756, (U64)0xB5AD5EB6, (U64)0x7555EAAB },
{ (U64)0xABAF7D76, (U64)0xBD6EF5EE, (U64)0xBF775DEF, (U64)0xD5DBB6BB, (U64)0xEAAAAAEE, (U64)0xAF5BF76A, (U64)0xDAAAD6DA, (U64)0x756BB76A, (U64)0xBAB6BFB5, (U64)0x6B57BB6A, (U64)0x6BD5B7D6, (U64)0x5DB7F576, (U64)0xAD55B75E, (U64)0xAADDDEDD, (U64)0xDFD7AEDD, (U64)0xD5EEFADF, (U64)0x5EAD5576, (U64)0xFF7EAAB5, (U64)0xD5D7AEAF, (U64)0xB5AADB5A, (U64)0xBAABDABE, (U64)0x6EBED6EF, (U64)0xDD5EEABA, (U64)0xBDAD6AAB, (U64)0x55ABAEBE, (U64)0xD55FB576, (U64)0x6BEB6EB7, (U64)0xF5FEB77F, (U64)0xBFDF56D5, (U64)0xDBD6BDFD, (U64)0x5D576FD7, (U64)0xEEADED6E, (U64)0xFB7ED6EB, (U64)0xDEAB7B6D, (U64)0xDAAF5555, (U64)0xBB6F5776, (U64)0x55ADB5EF, (U64)0xFDB6BEDB, (U64)0x5AAD5DBD, (U64)0x56AAD57A, (U64)0xAD6EAEFB, (U64)0x575D7B55, (U64)0xAAD6DEBB, (U64)0xDB6AEEBA, (U64)0x7AAD755A, (U64)0x75556EF5, (U64)0xEBAABD75, (U64)0x55AB56B5, (U64)0xEABAEAFA, (U64)0xD6BEB6F5, (U64)0xEBDAEDF5, (U64)0xF5576B6D, (U64)0x6AF5D7AA, (U64)0x5FBD6ADB, (U64)0xFFDF7AAB, (U64)0x5AB55DAD, (U64)0xBAD6DED6, (U64)0xB556B6B6, (U64)0xAABDB5B5, (U64)0x7D5B6B6F, (U64)0xAB5DEAAA, (U64)0xADADEFD5, (U64)0xB56AAD76, (U64)0xD6FEDD5A },
{ (U64)0xBAAD6EB7, (U64)0xAEAD5DAF, (U64)0x7756B5AB, (U64)0xAB5DD6B6, (U64)0xD7D7D6BA, (U64)0xBEB6AEDA, (U64)0xB56FDDD6, (U64)0xB5BADBAA, (U64)0xEAAAEB7A, (U64)0xEAAB575D, (U64)0x5B7BDEAA, (U64)0xDFB6AB56, (U64)0xD6F5D6D5, (U64)0x6BEEEB5B, (U64)0xB5FD76ED, (U64)0xABBD5AF5, (U64)0xBDB5B5DE, (U64)0x5ABEBAAA, (U64)0x6FD7EB5E, (U64)0x6EF7577E, (U64)0xDDBD7BFA, (U64)0xFFABAAEA, (U64)0x6D6AEAAD, (U64)0xABAB6EF5, (U64)0x5AB5757B, (U64)0xDD6ADB5D, (U64)0xB6DAAABA, (U64)0x5576DB6A, (U64)0x5D5EB55A, (U64)0xABB57575, (U64)0xAEABAEAE, (U64)0xAEBFAF56, (U64)0x55575EBB, (U64)0x5ABD77AD, (U64)0xD56AEB56, (U64)0x576B76DE, (U64)0xF7B5B556, (U64)0xFFF576BB, (U64)0x5AEAD6D5, (U64)0x5BF6AD56, (U64)0xDAB5ABDE, (U64)0x56D7AAEE, (U64)0x7ADB5F5D, (U64)0xFFBD5B55, (U64)0xED6BDD5F, (U64)0xD5D5AAEA, (U64)0x5D57D5EB, (U64)0x555FDBB7, (U64)0xF56EAABA, (U64)0xBAD7FAAA, (U64)0xB5B57AFA, (U64)0x5ABED7DD, (U64)0xBBADD6AF, (U64)0x76BFEAEA, (U64)0xEDD56D77, (U64)0xAB5556BA, (U64)0xB5DADEAD, (U64)0xAABAB7DB, (U64)0xAB6DBAF6, (U64)0xADDEB5BD, (U64)0x6BDBABB5, (U64)0x7DF55AD5, (U64)0xBDD5FAD5, (U64)0x5FAFAB5B },
{ (U64)0xBD575EAA, (U64)0x6B5D6B5F, (U64)0xBD575DEB, (U64)0xF5DB5BEB, (U64)0xAADBBBFB, (U64)0xDAFAADBD, (U64)0xB5D77BDD, (U64)0xDD755EBD, (U64)0x5AAEFAAD, (U64)0xF6AABAD6, (U64)0x557BEAAD, (U64)0xAEAAD6F6, (U64)0xB6FAD55A, (U64)0xFDB55AB6, (U64)0xD76D77AA, (U64)0xBABD6D7A, (U64)0x7F5ADAEB, (U64)0x75557ADA, (U64)0xDAAABEAD, (U64)0xD6F6F7FB, (U64)0xF57DD55A, (U64)0x5755555A, (U64)0xEF5B6EF6, (U64)0xB7DAED76, (U64)0xB75556DA, (U64)0xED56DAD5, (U64)0xAEEFD57B, (U64)0x6BD5B557, (U64)0x75F76AD5, (U64)0x6F57AAAE, (U64)0xD6D6D55B, (U64)0x7EB56ABB, (U64)0x575AF75D, (U64)0xDEDD76D5, (U64)0xAB75BDD5, (U64)0xEB5D556A, (U64)0xF6EF5BAB, (U64)0xDAD77577, (U64)0xB56B56BA, (U64)0x6EEF5555, (U64)0xB5FED6AA, (U64)0xDAB6DD7A, (U64)0xEEB5DF6D, (U64)0xDF5DAD6A, (U64)0xDFDEB57B, (U64)0x6EDDADEF, (U64)0xAD55AAAE, (U64)0x6D7AD5DF, (U64)0xEABB7AB6, (U64)0x6BBDFD6B, (U64)0xFD56EEEE, (U64)0x7AAABBAA, (U64)0xBDB7AEAE, (U64)0xED5BB755, (U64)0x55B5DEF5, (U64)0xAABBF6B7, (U64)0xEAADF6BE, (U64)0xD5EB7D7E, (U64)0x576DD7B7, (U64)0x5FDAEBEB, (U64)0xAB75AEDB, (U64)0xAAB5DD75, (U64)0xBB555ADA, (U64)0x6F5BFEAF },
{ (U64)0xB5D556AA, (U64)0xD6B7AEEE, (U64)0xF6DDB7AF, (U64)0x757D7B5D, (U64)0x5B5F7B5D, (U64)0xADEB56FE, (U64)0x5D5AAABA, (U64)0x5B6F556B, (U64)0xD55AABAD, (U64)0x5F7AABAA, (U64)0x55D7DD5B, (U64)0xAD6AB756, (U64)0xD5DD7FDB, (U64)0x5B6B5AAE, (U64)0xADED55EE, (U64)0xABBDF57B, (U64)0xB6AAAEF6, (U64)0xEFAADED7, (U64)0xD6DDB7DF, (U64)0xEADEBDDE, (U64)0xB7555BAD, (U64)0x6BB555B7, (U64)0xEB5D56AB, (U64)0xF5DD576E, (U64)0xDD5D75EA, (U64)0xF575AD7D, (U64)0xAABADAEE, (U64)0xBB5F5D6E, (U64)0xAAD57FDD, (U64)0xB56B6D5A, (U64)0xF5DAAAEB, (U64)0xDFAEF55A, (U64)0x5DAFF6EE, (U64)0xDEF55DAA, (U64)0xAADFB6AB, (U64)0x7B557F7D, (U64)0x57BAED7D, (U64)0xDABABD5E, (U64)0xAFB5ADB5, (U64)0x6B5B6DBA, (U64)0xAEEAB7BD, (U64)0xBABB57AA, (U64)0xDDAF57FB, (U64)0x6ABEAD6A, (U64)0xAB75D6AA, (U64)0xD6BAFBAE, (U64)0xDDF6AEDE, (U64)0x6D75B5FD, (U64)0xAAFB7D7A, (U64)0x55EDBB56, (U64)0xBAFEDB5B, (U64)0xB7DEFAAF, (U64)0xD6AEABAA, (U64)0xABAAED76, (U64)0xBB56DAB6, (U64)0xAD7D5BDB, (U64)0xAD5556AA, (U64)0x7BAD7ADE, (U64)0x55B7AAD7, (U64)0xED76D56A, (U64)0x7BEBD5AA, (U64)0xAB6B5ADB, (U64)0xFEFFB6ED, (U64)0xBADD77F5 },
{ (U64)0x7D7DEDAD, (U64)0xD57DDD5F, (U64)0xB6B75755, (U64)0xADD5BAB7, (U64)0x6EAABAB6, (U64)0x6D5F55BD, (U64)0x555D5EED, (U64)0xAAD56AFA, (U64)0x776EFDB5, (U64)0xDB5BEAB6, (U64)0x5B7D56AE, (U64)0x5AB575DD, (U64)0x6B5577FD, (U64)0x6DD575DB, (U64)0xD6B6AEB6, (U64)0xDAAFAAAA, (U64)0xAF5755AF, (U64)0x7BABB6BE, (U64)0xFEADFAAD, (U64)0xBBDEB755, (U64)0xB6ED76F5, (U64)0x5DF7BAB5, (U64)0x7BDFF55A, (U64)0xADF6F7D5, (U64)0xABB6BFB5, (U64)0xAED575BA, (U64)0x7AB6ED56, (U64)0xABF6B5AD, (U64)0xEBD5AD75, (U64)0xABBBEFD6, (U64)0xDAAF6AFA, (U64)0xB5D76DBA, (U64)0xEBB6B5BB, (U64)0xDEDEDFFD, (U64)0xAEB6B6BD, (U64)0x776EBB76, (U64)0xB756BB6F, (U64)0x55756FD6, (U64)0xB76D6EDF, (U64)0xB57EEAAE, (U64)0xBEBEFB56, (U64)0xEB76B5FB, (U64)0xDEF6D6AA, (U64)0x7BB6EEDE, (U64)0xB6AD77AF, (U64)0x5AD5F75A, (U64)0xD56EBAAA, (U64)0xD6FAD6D5, (U64)0x6D76EDBF, (U64)0xEB5AAEBD, (U64)0xDDEB756D, (U64)0xD5755BB6, (U64)0x56FDD7AF, (U64)0xD57ABADB, (U64)0xF556DBDE, (U64)0xBEADDB5E, (U64)0xED6D6ABE, (U64)0x576D75EA, (U64)0x5F6AF5FB, (U64)0xAADAFDAA, (U64)0xD55BD5BA, (U64)0xBF5555BE, (U64)0x6FEDAD5E, (U64)0xB5555ADA },
{ (U64)0xEBBD755D, (U64)0x5F5F6F7A, (U64)0xAD75AD7D, (U64)0x5EAAB6ED, (U64)0xBDBABADB, (U64)0x6ED56AAD, (U64)0x6B5F75AD, (U64)0xAABAB55E, (U64)0xB7EB56FA, (U64)0xBFBEAFAA, (U64)0xBB6FDF76, (U64)0x556DAAD5, (U64)0xBADAFD5D, (U64)0xABEBAD6E, (U64)0xFDD775B7, (U64)0xDED7EF6E, (U64)0xAAED6AAA, (U64)0x555AADFA, (U64)0xAD55D577, (U64)0xDDEAD7DA, (U64)0x7556F775, (U64)0x55F5D6DF, (U64)0xBEAAB55F, (U64)0x6AAEBADF, (U64)0xEF5ADABA, (U64)0x57AAADFE, (U64)0x6ABEAB56, (U64)0xEEEBAADB, (U64)0xAEB5B5EB, (U64)0x756DBBEA, (U64)0xFD7577AA, (U64)0xFAFB5AAB, (U64)0x6F6FAD5F, (U64)0xAEBDDFDF, (U64)0x77D55B6A, (U64)0xBEBFB75A, (U64)0xEEAED57B, (U64)0xF76FDEAD, (U64)0x6BADF56E, (U64)0xAADB7ADB, (U64)0xD6DAD756, (U64)0xDAAEBAFA, (U64)0xEBBD7B56, (U64)0x5DBAAAAD, (U64)0x55DDABB6, (U64)0xEEADAB7D, (U64)0xBFAAEDBD, (U64)0x55B7DB55, (U64)0xDED55555, (U64)0xB7D556F6, (U64)0xAADFBEAA, (U64)0x5DAD55EA, (U64)0xDD75BDAB, (U64)0xAB5D7EAB, (U64)0xB6AD6FD5, (U64)0x6ADDEABA, (U64)0xBBBBD555, (U64)0xED6EDBB7, (U64)0xEDB6AB56, (U64)0x6B5BEB77, (U64)0xABAB7FAA, (U64)0xB6EAFDFA, (U64)0xBEDBADAE, (U64)0x6D556D5D },
{ (U64)0xEBB6ABAF, (U64)0xB5DEDED5, (U64)0x5EB6BD55, (U64)0xD6B757DA, (U64)0xB576BEB7, (U64)0x6F557EDE, (U64)0xDBFAAB6A, (U64)0xAEF76B5E, (U64)0xF7556DEA, (U64)0x5EAAB5FA, (U64)0xBDB7556E, (U64)0x6DAB55EE, (U64)0x756F576D, (U64)0xF55AEABE, (U64)0xAABAAADE, (U64)0xBAAD7B7D, (U64)0xAFBB6D55, (U64)0xBEAF6ABE, (U64)0xBBEFAFDA, (U64)0xB6B55AB6, (U64)0xB56FB6BE, (U64)0xB75BEAAA, (U64)0xD76EBAAF, (U64)0xED5B6EDF, (U64)0xAEBD55EE, (U64)0x755BAF76, (U64)0x7D6AEAAA, (U64)0xF7B55B5A, (U64)0x6BDEEF5F, (U64)0xFD5DDAFA, (U64)0xAD5755BA, (U64)0x5ADB75BD, (U64)0xBD576DFA, (U64)0x5D55D6AA, (U64)0xD6EED57B, (U64)0xEAAADAEB, (U64)0xAAEBAAAD, (U64)0xB6ABAD5A, (U64)0xED7BAFEA, (U64)0x6DD6FD5A, (U64)0xF5EDDF6A, (U64)0xFB5AAEEB, (U64)0x55EADAD6, (U64)0xEDED76FD, (U64)0xAADAEB5D, (U64)0xAF6F5B6F, (U64)0xAB57756B, (U64)0x5DDFD5AF, (U64)0xEED6D7DB, (U64)0xBD7D5BB7, (U64)0xAEDB6FBE, (U64)0x5B56BBD5, (U64)0x5577AEEF, (U64)0xBD55B5F6, (U64)0xDD76EDDE, (U64)0x76BAB5DB, (U64)0xFB5ADD56, (U64)0x5DD6AADA, (U64)0xD5D7F7BB, (U64)0x576EDEB5, (U64)0xB5B7DD5F, (U64)0xF75EAFEA, (U64)0xD5AAAAFF, (U64)0x5DFADB5A}
};
#endif

/*******************************************************************************
					INICIO PROGRAMA
*******************************************************************************/

int main(int argc, char *argv[])
{
	char command[16350];
	srand((unsigned int)ObtenerTiempo());

	Salir = false;

	setbuf(stdout, NULL);
	setbuf(stdin, NULL);

	Iniciar_AlphaBeta();
	Inicializar_See();
	IniciarConfiguracion();

	/* Cargamos DLL */
#ifdef USAR_SQLITE
	LibroSql.Dll_Cargada = Cargar_sqlite_dll();
#endif
#ifdef USAR_TBPROBE
	Gaviota.Dll_Cargada = Cargar_gaviota_dll();
#endif
#ifdef USAR_NNUE
	Nnue.Dll_Cargada = Cargar_nnue_dll();
	CargarNnue();
#endif

	UciNewGame();

	for (;;)
	{
		memset(command, 0, 16350 * sizeof(char));
		LeerComandos(command, 16350);

		UciEntrada(command);

		if (Salir)
		{
			break;
		}
	}

#ifdef USAR_HASH_TB
	LiberarMemoria();
#endif
#ifdef USAR_TBPROBE
	Descargar_gaviota_dll();
#endif
#ifdef USAR_SQLITE
	Descargar_sqlite_dll();
#endif

    exit(EXIT_SUCCESS);
}

void UciEntrada(char *parametro)
{
	if (strncmp(parametro, "ucinewgame", 10) == 0)
	{
		UciNewGame();
		return;
	}
    else if (strncmp(parametro, "uci", 3) == 0)
	{
		printf("id name "NOMBRE" "VER"");
		#ifdef ARC_64BIT
			printf(""STRING_FORMAT"\n", " x64");
		#else
			printf(""STRING_FORMAT"\n", " x86");
		#endif
		fflush(stdout);
		printf("id author "AUTOR"\n");fflush(stdout);
		#ifdef USAR_HASH_TB
			printf("option name Hash type spin default "U64_FORMAT" min "S32_FORMAT" max "S32_FORMAT"\n", TT_Opciones.tt_Mb, MB_HASH_TABLE_MIN, MB_HASH_TABLE_MAX);
			fflush(stdout);
		#endif
		#ifdef USAR_SQLITE
			if (LibroSql.Dll_Cargada == true)
			{
				LibroSql.UsarLibro = ComprobarAccesoLibro();

				if (LibroSql.UsarLibro == true)
				{
					printf("option name OwnBook type check default true\n");
				}
				else
				{
					printf("option name OwnBook type check default false\n");
				}
				fflush(stdout);
				printf("option name OwnBookLimit type spin default "S32_FORMAT" min 2 max 10\n", LibroSql.LimiteJugadas);
				fflush(stdout);
			}
		#endif
			switch (TipoJuego.MostrarVp)
			{
			case 0:
				printf("option name ShowPv type combo default None var None var Middle var Full\n");
				break;
			case 1:
				printf("option name ShowPv type combo default Middle var None var Middle var Full\n");
				break;
			case 2:
				printf("option name ShowPv type combo default Full var None var Middle var Full\n");
				break;
			default:
				break;
			}
			fflush(stdout);
		#ifdef USAR_TBPROBE
			if (Gaviota.Dll_Cargada == true)
			{
				if (Gaviota.Usar == true)
				{
					printf("option name GaviotaUse type check default true\n");
				}
				else
				{
					printf("option name GaviotaUse type check default false\n");
				}
				fflush(stdout);
				if (Gaviota.Directorio[0] == '\0')
					printf("option name GaviotaPath type string default "STRING_FORMAT"\n", "<empty>");
				else
					printf("option name GaviotaPath type string default "STRING_FORMAT"\n", Gaviota.Directorio);

				fflush(stdout);
				printf("option name GaviotaCache type spin default "U64_FORMAT" min "S32_FORMAT" max "S32_FORMAT"\n", Gaviota.CacheMB, MB_GAVIOTA_CACHE_MIN, MB_GAVIOTA_CACHE_MAX);
				fflush(stdout);
				printf("option name GaviotaProbeLimit type spin default "S32_FORMAT" min 3 max 5\n", Gaviota.Limite);
				fflush(stdout);
			}
		#endif
		#ifdef USAR_NNUE
			if (Nnue.Dll_Cargada == true)
			{
				if (Nnue.Usar == true)
				{
					printf("option name NnueUse type check default true\n");
				}
				else
				{
					printf("option name NnueUse type check default false\n");
				}
				fflush(stdout);

				if (Nnue.Directorio[0] == '\0')
					printf("option name NnuePath type string default "STRING_FORMAT"\n", "<empty>");
				else
					printf("option name NnuePath type string default "STRING_FORMAT"\n", Nnue.Directorio);
				fflush(stdout);
			}
		#endif
		#ifdef USAR_AJEDREZ960
			if (TipoJuego.Ajedrez960 == true)
			{
				printf("option name UCI_Chess960 type check default true\n");
			}
			else
			{
				printf("option name UCI_Chess960 type check default false\n");
			}
			fflush(stdout);
			switch (TipoJuego.Ajedrez960Enroque)
			{
			case false:
				printf("option name UCI_Chess960CastlingSign type combo default UCI var UCI var O-O/O-O-O\n");
				break;
			case true:
				printf("option name UCI_Chess960CastlingSign type combo default O-O/O-O-O var UCI var O-O/O-O-O\n");
				break;
			default:
				break;
			}
			fflush(stdout);
#endif

		printf("uciok\n");
		fflush(stdout);
		return;
    }
	else if (strncmp(parametro, "isready", 7) == 0)
	{
		printf("readyok\n");
		fflush(stdout);
		return;
	}
	else if (strncmp(parametro, "setoption", 9) == 0)
	{
		parametro += 10;	/* setoption */
		parametro += 5;		/* name */
		Setoption(parametro);
		return;
	}
	else if (strncmp(parametro, "position", 8) == 0)
	{
		parametro += 9;	/* position */
		Position_Fen_Startpos(parametro);
		return;
	}
	else if (strncmp(parametro, "go", 2) == 0)
	{
		parametro += 3;	/* go */
		if (TipoJuego.JugadaIlegal == false)
			InicioBusqueda(parametro);

		return;
	}
#ifdef USAR_SQLITE
	else if (strncmp(parametro, "book", 4) == 0 && LibroSql.Dll_Cargada == true)
	{
		VerificarLibroApertura();
		return;
	}
#endif
	else if (strncmp(parametro, "perftdiv", 8) == 0)
	{
		parametro += 9;	/* perftdiv */
		if (Es_Numero(parametro))
		{
			TipoJuego.MaxDepth = (int)atoll(parametro);
			Perft(true);
		}
	}
	else if (strncmp(parametro, "perft", 5) == 0)
	{
		parametro += 6;	/* perft */

		if (Es_Numero(parametro))
		{
			if ((int)atoll(parametro) == -1)
				;
			else
				TipoJuego.MaxDepth = (int)atoll(parametro);

			Perft(false);
		}
	}
	else if (strncmp(parametro, "quit", 4) == 0)
	{
		Salir = true;
		return;
	}
}

void LeerComandos(char *entrada, int longitud)
{
	fflush(stdout);
	/* Si en la entrada no contiene nada */
	if (fgets(entrada, longitud, stdin) == NULL)
	{
		Salir = true;
		return;
	}

	if (strchr(entrada, '\n') != NULL)
	{
		if (strlen(entrada) > 0)
		{
			entrada[strlen(entrada) - 1] = '\0';
		}
	}
	if (strchr(entrada, '\r') != NULL)
	{
		if (strlen(entrada) > 0)
		{
			entrada[strlen(entrada) - 1] = '\0';
		}
	}
}

void Position_Fen_Startpos(char *ptr)
{
	char contenedor[MAX_DIR];
	char fen[MAX_DIR];
	int Ok = false;
	char buffer[MAX_DIR];

	LimpiarPuntuacion();
	memset(contenedor, '\0', MAX_DIR * sizeof(char));

	TipoJuego.NJugadasTotales = 0;
	TableroGlobal.Regla_50_Movimiento = 0;
#ifdef USAR_HASH_TB
	TableroGlobal.Hply = 0;
#endif

	ptr = Split_String(ptr, contenedor, MAX_DIR);
	if (strcmp(contenedor, "fen") == 0)
	{
		memset(fen, '\0', MAX_DIR * sizeof(char));
		fen[strlen(fen)] = '\0';

		for (;;)
		{
			memset(contenedor, '\0', MAX_DIR * sizeof(char));
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (*contenedor == '\0' || strcmp(contenedor, "moves") == 0)
			{
				break;
			}

            if (MAX_DIR - 2 > (strlen(fen) + strlen(contenedor)))
			{
				strcat(fen, contenedor);
				strcat(fen, " ");
			}

		}

		if (!CargarFen(fen))
		{
			printf("FEN format incorrect.\n");
			fflush(stdout);
			memset(buffer, 0, MAX_DIR * sizeof(char));
			strcpy(buffer, START_POS);
			Position_Fen_Startpos(buffer);
			return;
		}

		/* Desde una posicin Fen, el libro no encuentra variaciones de aperturas, lo finalizamos */
#ifdef USAR_SQLITE
		if (TipoJuego.Ajedrez960 == false)
			LibroSql.FinVariacion = true;
#endif
	}
	else /* Posicin inicial (STARTPOS) */
	{
		memset(contenedor, 0, MAX_DIR * sizeof(char));
		ptr = Split_String(ptr, contenedor, MAX_DIR);
		memset(buffer, 0, MAX_DIR * sizeof(char));
		strcpy(buffer, START_POS);
		if (!CargarFen(buffer))
		{
			Salir = true;
			return; 
		}
#ifdef USAR_SQLITE
		LibroSql.FinVariacion = false;
#endif
	}

#ifdef USAR_HASH_TB
	/* Obtenemos el key del tablero */
	ObtenerKey();
#endif

	/* Existen movimientos */
	if (strcmp(contenedor, "moves") == 0)
	{
		/* Reiniciamos el libro de aperturas */
#ifdef USAR_SQLITE
		if (*ptr != '\0' && LibroSql.Dll_Cargada == true)
		{
			ptr++;
			ListaJugadas(ptr, strlen(ptr));
		}
#endif

		for (;;)
		{
			memset(contenedor, 0, MAX_DIR * sizeof(char));
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (*contenedor == '\0')
			{
				break;
			}

			Movimiento(contenedor, &Ok, (!strlen(ptr)));
		}
	}
}

void InicioBusqueda(char *ptr) {
	char contenedor[MAX_DIR];
	int wtime = 0;
	int btime = 0;
	int winc = 0;
	int binc = 0;
	U64 inc = 0;
	U64 time = 0;
	U64 movetime = 0;
	int NJugadasTotales = 0;
	int Ok = false;

	TipoJuego.BuscarNodos = 0;
	TipoJuego.BuscarMate = 0;

	/*Buscamos en el libro de aperturas */
#ifdef USAR_SQLITE
	if (LibroSql.Dll_Cargada == true)
	{
		char move[6];
		memset(move, 0, 5 * sizeof(char));

		if (LibroSql.UsarLibro == true && BuscarJugadaLibro())
		{
			ObtenerJugadaLibro(move);
			printf("bestmove ");

#ifdef USAR_AJEDREZ960
			if (TipoJuego.Ajedrez960 == true)
			{
				if (TipoJuego.Ajedrez960Enroque == true)
				{
					_ST_Movimiento nextMoves[MAX_JUGADAS];
					int NumeroDeMovimientos = 0;
					int j = 0;
					char mov[6];

					NumeroDeMovimientos = GenerarMovimientos(Todos, nextMoves);

					for (j = 0; j < NumeroDeMovimientos; j++)
					{
						memset(mov, 0, 6 * sizeof(char));

						MovimientoCoordenadas(CUADRADO_ORIGEN(nextMoves[j].Movimiento), CUADRADO_DESTINO(nextMoves[j].Movimiento), CORONACION(nextMoves[j].Movimiento), mov);

						if (strcmp(move, mov) == 0)
						{
							if (ENROQUE(nextMoves[j].Movimiento) == MFLAGCA)
							{
								if (CUADRADO_ORIGEN(nextMoves[j].Movimiento) < CUADRADO_DESTINO(nextMoves[j].Movimiento))
								{
									memset(move, 0, 6 * sizeof(char));
									strcat(move, "O-O");
								}
								else/* Enroque largo */
								{
									memset(move, 0, 6 * sizeof(char));
									strcat(move, "O-O-O");
								}
								break;
							}
						}
					}
				}
			}
#endif

			printf(""STRING_FORMAT"\n", move);
			fflush(stdout);
			return;
		}
	}
#endif

	memset(contenedor, 0, MAX_DIR * sizeof(char));

	TipoJuego.MaxDepth = 0;
	TipoJuego.Infinito = false;

	for (;;)
	{
		ptr = Split_String(ptr, contenedor, MAX_DIR);
		if (*contenedor == '\0')
		{
			break;
		}

		if (strcmp(contenedor, "wtime") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					wtime = (int)atoll(contenedor);
			}
		}
		else if (strcmp(contenedor, "btime") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					btime = (int)atoll(contenedor);
			}
		}
		else if (strcmp(contenedor, "winc") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					winc = (int)atoll(contenedor);
			}
		}
		else if (strcmp(contenedor, "binc") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					binc = (int)atoll(contenedor);
			}
		}
		else if (strcmp(contenedor, "infinite") == 0)
		{
			TipoJuego.Infinito = true;
			TipoJuego.MaxDepth = (MAX_PLY / 2);
		}
		else if (strcmp(contenedor, "depth") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) + 1 == -1)
					;
				else
					TipoJuego.MaxDepth = (int)atoll(contenedor) + 1;
			}
			if (TipoJuego.MaxDepth > MAX_PLY / 2)
			{
				TipoJuego.MaxDepth = (MAX_PLY / 2);
			}
		}
		else if (strcmp(contenedor, "movestogo") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					NJugadasTotales = (int)atoll(contenedor);
			}
		}
		else if (strcmp(contenedor, "movetime") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					movetime = (int)atoll(contenedor);
			}
		}
		else if (strcmp(contenedor, "nodes") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					TipoJuego.BuscarNodos = (U64)atoll(contenedor);

				if (TipoJuego.BuscarNodos > 0)
				{
					TipoJuego.Infinito = true;
					TipoJuego.MaxDepth = (MAX_PLY / 2);
				}
			}
		}
		else if (strcmp(contenedor, "mate") == 0)
		{
			ptr = Split_String(ptr, contenedor, MAX_DIR);
			if (Es_Numero(contenedor))
			{
				if ((int)atoll(contenedor) == -1)
					;
				else
					TipoJuego.BuscarMate = (int)atoll(contenedor);

				if (TipoJuego.BuscarMate > 0)
				{
					TipoJuego.Infinito = true;
					TipoJuego.MaxDepth = (MAX_PLY / 2);
				}
			}
		}
	}

	time = TableroGlobal.MueveBlancas == true ? wtime : btime;
	inc = TableroGlobal.MueveBlancas == true ? winc : binc;

	/***************************************************************************************************
								Partida por profundidad fija
	***************************************************************************************************/
	if (TipoJuego.MaxDepth != 0)
	{
		/* Ya obtenemos la profundidad indicada */
		TipoJuego.Activo = false;
		Ok = true;
	}
	/**************************************************************************************************
								Partida con tiempo fijo por movimiento
								go movetime 6000 - Tiempo por jugada
	**************************************************************************************************/
	if (movetime != 0)
	{
		TipoJuego.MaxDepth = (MAX_PLY / 2);
		TipoJuego.Activo = true;
		int f = movetime * 0.05 > 150 ? 150 : movetime * 0.05 <= 15 ? 20: (int)(movetime * 0.05f);
		TipoJuego.Tiempo = movetime - f;
		Ok = true;
	}
	/**************************************************************************************************
								Partida con tiempo y movimientos a realizar
							go wtime 298908 btime 300000 winc 0 binc 0 movestogo 49
	**************************************************************************************************/
	if (NJugadasTotales != 0 && wtime != 0 && btime != 0)
	{
		TipoJuego.MaxDepth = (MAX_PLY / 2);
		TipoJuego.Activo = true;
		TipoJuego.NJugadasTotales = NJugadasTotales;
		if (TipoJuego.NJugadasTotales == 0)
		{
			TipoJuego.NJugadasTotales = 1;
		}
		TipoJuego.Tiempo = (time / TipoJuego.NJugadasTotales) + (inc * 0.6);
		Ok = true;
	}
	/**************************************************************************************************
								Partida con tiempo y movimientos a realizar
								go wtime 298908 btime 300000 winc 0 binc 0
								go wtime 298908 btime 300000 winc 2000 binc 2000
	**************************************************************************************************/
	if (NJugadasTotales == 0 && wtime != 0 && btime != 0)
	{
		TipoJuego.MaxDepth = (MAX_PLY / 2);
		TipoJuego.Activo = true;

		TipoJuego.NJugadasTotales = 130 - TipoJuego.NJugadasTotales;

		if (TipoJuego.NJugadasTotales < 2)
		{
			TipoJuego.NJugadasTotales = 2;
		}

		if (time > 10000 && time < 20000) /* entre 10 y 20 segundos. Reducimos el tiempo. */
		{
			TipoJuego.Tiempo = (time / TipoJuego.NJugadasTotales) + inc;
			if (TipoJuego.Tiempo < 1000)
			{
				if (inc)
				{
					TipoJuego.Tiempo = inc;
				}
				else
				{
					TipoJuego.Tiempo = 1000;
				}
			}
		}
		else if (time < 10000) /* menor de 10 segundos. Reducimos el tiempo ms. */
		{
			if (inc)
			{
				TipoJuego.Tiempo = inc;
			}
			else
			{
				TipoJuego.Tiempo = 500;
			}
		}
		else
		{
			TipoJuego.Tiempo = time / TipoJuego.NJugadasTotales + 250 + inc;
		}
		Ok = true;
	}

	/* Lanzamos la bsqueda */
	if (Ok == true)
	{
		Buscar();
	}
	else
	{
		return;
	}

}

void IniciarConfiguracion()
{
#ifdef USAR_SQLITE
	int y = 0;
#endif

#ifdef USAR_HASH_TB
	TT_Opciones.tt_Mb = MB_HASH_TABLE;
	CrearTransposicion(TT_Opciones.tt_Mb);
#endif

	TipoJuego.Ajedrez960 = false;
	TipoJuego.Ajedrez960Enroque = false;

#ifdef USAR_SQLITE
	LibroSql.UsarLibro = false;
	LibroSql.LimiteJugadas = 8;
	for (y = 0; y < 11; y++)
	{
		LibroSql.SqlTabla[y] = 0;
	}
	for (y = 0; y < 9; y++)
	{
		LibroSql.Variante[y] = 0;
	}
	LibroSql.AperturaEstandar = true;
	strcpy(LibroSql.SqlTabla, "Book");
#endif

#ifdef USAR_TBPROBE
	Gaviota.Usar = false;										/* Usar tablas de gaviota */
	Gaviota.Dll_Cargada = false;								/* Si la .dll esta cargada */
	memset(Gaviota.Directorio, 0, MAX_DIR * sizeof(char));		/* Limpiamos la ruta */
	Gaviota.DirectorioNuevo = false;							/* Indica un cambio de directorio, para un re-load en caso de que si. */

	Gaviota.Informacion = true;								/* Muestra informacin 0 = non-verbose, 1 = verbose */
	Gaviota.Compresion = 4;										/* Compresin solo .cp4 */
	Gaviota.Limite = 5;											/* Numero de piezas mximas para empezar a buscar. */
	Gaviota.CacheMB = MB_GAVIOTA_CACHE;							/* Cache para las bases de datos */
	Gaviota.CacheNueva = false;									/* Si hay un cambio de valor en la cache, para un re-load */
	Gaviota.Fraccion = 0;										/* 	wdl_fraction:	0 = Solo DTM	128 = Solo WDL
																	fraction, over 128, that will be dedicated to wdl information.
																	In other words, 96 means 3/4 of the cache will be dedicated to
																	win-draw-loss info, and 1/4 dedicated to distance to mate
																	information.
																*/
#endif

#ifdef USAR_NNUE
	Nnue.Usar = true;												/* Usar NNUE */
	Nnue.Dll_Cargada = false;										/* Si la .dll esta cargada. */
	memset(Nnue.Directorio, 0, MAX_DIR * sizeof(char));				/* Limpiamos la ruta */
	strcpy(Nnue.Directorio, "nn-a9f9e868162a.nnue");
	Nnue.DirectorioNuevo = false;
#endif

	TipoJuego.MostrarVp = 1;
}

void Setoption(char *ptr)
{
	char contenedor[MAX_DIR];
	char nombre[MAX_DIR];
	char valor[MAX_DIR];

	memset(contenedor, '\0', MAX_DIR * sizeof(char));
	memset(nombre, '\0', MAX_DIR * sizeof(char));
	memset(valor, '\0', MAX_DIR * sizeof(char));

	sscanf(ptr, "%255s %5s %255s", nombre, contenedor, valor);


	/********************************************************************************
							HASH TABLE
	********************************************************************************/
#ifdef USAR_HASH_TB
	if (strcmp(nombre, "Hash") == 0)
	{
		if (Es_Numero(valor))
		{
#ifdef USAR_HASH_TB
			/* Creamos la nueva tabla */
			if ((int)atoll(valor) == -1)
				;
			else
				TT_Opciones.tt_Mb = (int)atoll(valor);

			if ((int)atoll(valor) > MB_HASH_TABLE_MAX)
			{
				TT_Opciones.tt_Mb = MB_HASH_TABLE;
			}
			else
			{
				if (TT_Opciones.tt_Mb < MB_HASH_TABLE_MIN || TT_Opciones.tt_Mb > MB_HASH_TABLE_MAX)
				{
					TT_Opciones.tt_Mb = MB_HASH_TABLE;
				}
			}

			CrearTransposicion(TT_Opciones.tt_Mb);
#endif
		}
	}
#endif
	/*************************************************************************
								MostrarVp
	*************************************************************************/
#ifdef USAR_PVS
	if (strcmp(nombre, "ShowPv") == 0)
	{
		if (strcmp(valor, "None") == 0)
		{
			TipoJuego.MostrarVp = 0;
		}
		else if (strcmp(valor, "Middle") == 0)
		{
			TipoJuego.MostrarVp = 1;
		}
		else if (strcmp(valor, "Full") == 0)
		{
			TipoJuego.MostrarVp = 2;
		}
	}

#endif
	/********************************************************************************
							LIBRO DE APERTURAS
	********************************************************************************/
#ifdef USAR_SQLITE
	if (LibroSql.Dll_Cargada == true)
	{
		if (strcmp(nombre, "OwnBook") == 0)
		{
			if (strcmp(valor, "true") == 0)
			{
				LibroSql.UsarLibro = true;
			}
			else if (strcmp(valor, "false") == 0)
			{
				LibroSql.UsarLibro = false;
			}
		}
		/*				LIMITE				*/
		if (strcmp(nombre, "OwnBookLimit") == 0)
		{
			if (Es_Numero(valor))
			{
				if ((int)atoll(valor) == -1)
					;
				else
					LibroSql.LimiteJugadas = (int)atoll(valor);

				if (LibroSql.LimiteJugadas >= 2 && LibroSql.LimiteJugadas <= 10)
				{
					;
				}
				else
				{
					LibroSql.LimiteJugadas = 8;
				}
			}
		}
	}
#endif
	/*************************************************************************
	TABLE BASES GAVIOTA
	*************************************************************************/
#ifdef USAR_TBPROBE
	if (Gaviota.Dll_Cargada == true)
	{
		/*				USAR			*/
		if (strcmp(nombre, "GaviotaUse") == 0)
		{
			if (strcmp(valor, "true") == 0)
			{
				Gaviota.Usar = true;
			}
			else if (strcmp(valor, "false") == 0)
			{
				Gaviota.Usar = false;
			}
		}
		/*				RUTA			*/
		if (strcmp(nombre, "GaviotaPath") == 0)
		{
			if (strcmp(valor, Gaviota.Directorio) == 0)
				Gaviota.DirectorioNuevo = false;
			else
				Gaviota.DirectorioNuevo = true;

			if (strcmp(valor, "<empty>") == 0)
			{
				;
			}
			else if (strcmp(valor, "") == 0)
			{
				;
			}
			else
			{
				if (Gaviota.DirectorioNuevo == true)
				{
					if (Gaviota.paths != NULL)
						TBpaths_done(Gaviota.paths);
					memset(Gaviota.Directorio, 0, MAX_DIR * sizeof(char));
					strcat(Gaviota.Directorio, valor);
				}
			}

			if (Gaviota.DirectorioNuevo == true)
			{
				CargarGaviotaTB();
			}
		}
		/*				CACHE			*/
		if (strcmp(nombre, "GaviotaCache") == 0)
		{
			if (Es_Numero(valor))
			{
				/* Compruebo diferencia de cache */
				if ((int)atoll(valor) == (int)Gaviota.CacheMB)
					Gaviota.CacheNueva = false;
				else
					Gaviota.CacheNueva = true;

				/* Es un valor fuera de rango */
				if ((int)atoll(valor) == -1)
					;
				else
					Gaviota.CacheMB = atoll(valor);	

				/* Esta fuera de lo permitido */
				if (Gaviota.CacheMB > MB_GAVIOTA_CACHE_MAX)
				{
					Gaviota.CacheMB = MB_GAVIOTA_CACHE;
				}
				else if (Gaviota.CacheMB < MB_GAVIOTA_CACHE_MIN)
				{
					Gaviota.CacheMB = MB_GAVIOTA_CACHE;
				}

				CacheGaviotaTB();
			}
		}
		/*			MAN - Limite			*/
		if (strcmp(nombre, "GaviotaProbeLimit") == 0)
		{
			if (Es_Numero(valor))
			{
				if ((int)atoll(valor) == -1)
					;
				else
					Gaviota.Limite = (int)atoll(valor);

				if (Gaviota.Limite < 3 || Gaviota.Limite > 5)
				{
					Gaviota.Limite = 5;
				}
			}
		}
	}
#endif

	/*************************************************************************
	NNUE
	*************************************************************************/
#ifdef USAR_NNUE
	if (Nnue.Dll_Cargada == true)
	{
		/*				USAR			*/
		if (strcmp(nombre, "NnueUse") == 0)
		{
			if (strcmp(valor, "true") == 0)
			{
				Nnue.Usar = true;
			}
			else if (strcmp(valor, "false") == 0)
			{
				Nnue.Usar = false;
			}
		}
		/*				RUTA			*/
		if (strcmp(nombre, "NnuePath") == 0)
		{
			if (strcmp(valor, Nnue.Directorio) == 0)
				Nnue.DirectorioNuevo = false;
			else
				Nnue.DirectorioNuevo = true;

			memset(Nnue.Directorio, 0, MAX_DIR * sizeof(char));

			if (strcmp(valor, "<empty>") == 0)
			{
				;
			}
			else if (strcmp(valor, "") == 0)
			{
				;
			}
			else
			{
				strcat(Nnue.Directorio, valor);
			}

			if (Nnue.DirectorioNuevo == true)
			{
				CargarNnue();
			}
		}
	}
#endif
	/*************************************************************************
							CHES960
	*************************************************************************/
#ifdef USAR_AJEDREZ960
	if (strcmp(nombre, "UCI_Chess960") == 0)
	{
		if (strcmp(valor, "true") == 0)
		{
			TipoJuego.Ajedrez960 = true;
#ifdef USAR_SQLITE
			/* Libro de aperturas */
			LibroSql.AperturaEstandar = false;
			memset(LibroSql.SqlTabla, 0, 11 * sizeof(char));
			memset(LibroSql.Variante, 0, 9 * sizeof(char));
			strcpy(LibroSql.SqlTabla, "Chess960");
#endif
		}
		else if (strcmp(valor, "false") == 0)
		{
			TipoJuego.Ajedrez960 = false;
#ifdef USAR_SQLITE
			/* Libro de aperturas */
			LibroSql.AperturaEstandar = true;
			memset(LibroSql.SqlTabla, 0, 11 * sizeof(char));
			memset(LibroSql.Variante, 0, 9 * sizeof(char));
			strcpy(LibroSql.SqlTabla, "Book");
#endif
		}
	}

	if (strcmp(nombre, "UCI_Chess960CastlingSign") == 0)
	{
		if (strcmp(valor, "UCI") == 0)
		{
			TipoJuego.Ajedrez960Enroque = false;
		}
		else if (strcmp(valor, "O-O/O-O-O") == 0)
		{
			TipoJuego.Ajedrez960Enroque = true;
		}
	}

#endif
}

void CacheGaviotaTB()
{
#ifdef USAR_TBPROBE
	U64 CacheMB = Gaviota.CacheMB * (U64)1024 * (U64)1024;
	if (Gaviota.CacheNueva == true || TBcache_is_on() == false)
	{
		Gaviota.CacheNueva = false;
		TBcache_init(CacheMB, Gaviota.Fraccion);
		if (TBcache_is_on())
		{
			printf("Gaviota state cache: Ok\n");
			fflush(stdout);
		}
		else
		{
			printf("Gaviota state cache: Failed\n");
			fflush(stdout);
		}
	}
#endif
}
void CargarGaviotaTB()
{
#ifdef USAR_TBPROBE
	/* Se puede usar las tablas de finales de gaviota */
	if (Gaviota.Dll_Cargada == true)
	{
		char *initinfo = NULL;
		if (Gaviota.Directorio[0] != '\0')
		{
			if (TBis_initialized() == false)
			{
				Gaviota.paths = TBpaths_init();
				Gaviota.paths = TBpaths_add(Gaviota.paths, Gaviota.Directorio);
				initinfo = TBinit(Gaviota.Informacion, Gaviota.Compresion, Gaviota.paths);
			}
			else
			{
				if (Gaviota.DirectorioNuevo == true)
				{
					Gaviota.DirectorioNuevo = false;
					Gaviota.paths = TBpaths_init();
					Gaviota.paths = TBpaths_add(Gaviota.paths, Gaviota.Directorio);
					initinfo = TBrestart(Gaviota.Informacion, Gaviota.Compresion, Gaviota.paths);
				}
			}

			Gaviota.Tablas_Disponibles = TBavailability();

			if (initinfo != NULL)
			{
				printf(""STRING_FORMAT"\n", initinfo);
				fflush(stdout);
			}
			if (Gaviota.Tablas_Disponibles != 0 && TBis_initialized())
			{
				printf("Gaviota initialized: Ok\n");
				fflush(stdout);
			}
			else
			{
				printf("Gaviota initialized: Failed\n");
				fflush(stdout);
			}

			/* Cargamos la cache */
			CacheGaviotaTB();
		}
	}
#endif
}
void CargarNnue()
{
#ifdef USAR_NNUE
	/* Se puede usar las tablas de finales de gaviota */
	if (Nnue.Dll_Cargada == true && Nnue.Directorio[0] != '\0')
	{
		/* Si es posible cargar la DLL */
		Nnue.DirectorioNuevo = false;
		if (NNUE_init(Nnue.Directorio) == false)
		{
			Nnue.Usar = false;
			printf("Loading NNUE: "STRING_FORMAT"\n", Nnue.Directorio);
			printf("NNUE file not found or Unsupported.\n");
			fflush(stdout);
		}
	}
#endif
}
void UciNewGame()
{
	int i = 0;
	int blanconegro = 0;
	char buffer[MAX_DIR];
	memset(buffer, 0, MAX_DIR * sizeof(char));

	/* Iniciamos el tablero de los colores del tablero */
	for (i = 0; i < 64; i++)
	{
		if (i == 0)
		{
			blanconegro = 0;
		}
		if (i == 8)
		{
			blanconegro = 1;
		}
		if (i == 16)
		{
			blanconegro = 0;
		}
		if (i == 24)
		{
			blanconegro = 1;
		}
		if (i == 32)
		{
			blanconegro = 0;
		}
		if (i == 40)
		{
			blanconegro = 1;
		}
		if (i == 48)
		{
			blanconegro = 0;
		}
		if (i == 56)
		{
			blanconegro = 1;
		}

		TableroGlobal.TableroColor[i] = blanconegro = !blanconegro;
	}

#ifdef USAR_SQLITE
	LibroSql.FinVariacion = false;
#endif

	TableroGlobal.MueveBlancas = true;
	TableroGlobal.Regla_50_Movimiento = 0;

#ifdef USAR_HASH_TB
	memset(TableroGlobal.Historico, 0, MAX_HISTORICO * sizeof(U64));
	TableroGlobal.Hply = 0;
#endif

	A_Inicio(true);

	TipoJuego.Activo = false;
	TipoJuego.Infinito = false;
	TipoJuego.Tiempo = 0;
	TipoJuego.TiempoTranscurrido = 0;
	TipoJuego.Inicio = 0;
	TipoJuego.Interrumpir = false;
	TipoJuego.MaxDepth = (MAX_PLY / 2);
	TipoJuego.NJugadasTotales = 0;
	strcpy(buffer, START_POS);
	Position_Fen_Startpos(buffer);
}

void Movimiento(char *ptr, int *Ok, int Ultimo)
{
	_ST_Movimiento nextMoves[MAX_JUGADAS];
	int NumeroDeMovimientos = 0;
	int j = 0;
	char mov[6];
	char _Enroque[6];
	int Legal = false;

	TableroGlobal.Ply = 0;
	NumeroDeMovimientos = GenerarMovimientos(Todos, nextMoves);

	for (j = 0; j < NumeroDeMovimientos; j++)
	{
		memset(mov, '\0', 6 * sizeof(char));
		memset(_Enroque, '\0', 6 * sizeof(char));
#ifdef USAR_AJEDREZ960
		if (TipoJuego.Ajedrez960 == true)
		{
			if (strcmp(ptr, "O-O") == 0)
			{
				memset(_Enroque, 0, 6 * sizeof(char));
				if (TableroGlobal.MueveBlancas == true)
				{
					MovimientoCoordenadas(TableroGlobal.PosicionReyB, TableroGlobal.Ajedrez960.TorreBlancaH, 0, _Enroque);
				}
				else
				{
					MovimientoCoordenadas(TableroGlobal.PosicionReyN, TableroGlobal.Ajedrez960.TorreNegraH, 0, _Enroque);
				}

				if (ENROQUE(nextMoves[j].Movimiento) == MFLAGCA)
				{
					MovimientoCoordenadas(CUADRADO_ORIGEN(nextMoves[j].Movimiento), CUADRADO_DESTINO(nextMoves[j].Movimiento), CORONACION(nextMoves[j].Movimiento), mov);
				}
				else
				{
					strcat(mov, "0000");
				}
			}
			else if (strcmp(ptr, "O-O-O") == 0)
			{
				memset(_Enroque, '\0', 6 * sizeof(char));
				if (TableroGlobal.MueveBlancas == true)
				{
					MovimientoCoordenadas(TableroGlobal.PosicionReyB, TableroGlobal.Ajedrez960.TorreBlancaA, 0, _Enroque);
				}
				else
				{
					MovimientoCoordenadas(TableroGlobal.PosicionReyN, TableroGlobal.Ajedrez960.TorreNegraA, 0, _Enroque);
				}

				if (ENROQUE(nextMoves[j].Movimiento) == MFLAGCA)
				{
					MovimientoCoordenadas(CUADRADO_ORIGEN(nextMoves[j].Movimiento), CUADRADO_DESTINO(nextMoves[j].Movimiento), CORONACION(nextMoves[j].Movimiento), mov);
				}
				else
				{
					strcat(mov, "0000");
				}
			}
			else
			{
				MovimientoCoordenadas(CUADRADO_ORIGEN(nextMoves[j].Movimiento), CUADRADO_DESTINO(nextMoves[j].Movimiento), CORONACION(nextMoves[j].Movimiento), mov);
			}

			_Enroque[strlen(_Enroque)] = '\0';
			mov[strlen(mov)] = '\0';

			if (strcmp(ptr, mov) == 0 || strcmp(_Enroque, mov) == 0)
			{
				Legal = HacerMovimiento(nextMoves[j].Movimiento, Ultimo);
				if (Legal == false)
				{
					printf("Illegal move: "STRING_FORMAT"\n", ptr);
					TipoJuego.JugadaIlegal = true;
					fflush(stdout);
					break;
				}
				*Ok = true;
#ifdef USAR_HASH_TB
				TableroGlobal.Historico[TableroGlobal.Hply++] = TableroGlobal.Hash;
#endif
				TipoJuego.NJugadasTotales++;
				break;
			}
		}
		else
		{
#endif
			MovimientoCoordenadas(CUADRADO_ORIGEN(nextMoves[j].Movimiento), CUADRADO_DESTINO(nextMoves[j].Movimiento), CORONACION(nextMoves[j].Movimiento), mov);
			if (strcmp(ptr, mov) == 0)
			{
				Legal = HacerMovimiento(nextMoves[j].Movimiento, Ultimo);
				if (Legal == false)
				{
					printf("Illegal move: "STRING_FORMAT"\n", ptr);
					TipoJuego.JugadaIlegal = true;
					fflush(stdout);
					break;
				}
				*Ok = true;
#ifdef USAR_HASH_TB
				TableroGlobal.Historico[TableroGlobal.Hply++] = TableroGlobal.Hash;
#endif
				TipoJuego.NJugadasTotales++;
				break;
			}
#ifdef USAR_AJEDREZ960
		}
#endif
	}
}
